#include "globals.h"


Vulcan::Vulcan(int x, int y, int w, int h, int speed, int p, bool active, bool fired, int a, bool hostile)
{    
    this->x = x;
    this->y = y;
    this->width = w;
    this->height = h;
    this->speed = speed;
    power = p;
    this->active = active;
    this->fired = fired;
    
    angle = a;
    
    this->hostile = hostile;
    
    animation = new Animation(BitmapManager::getBitmap(VULCAN_SPRITE), 5, 4, BY_WIDTH);
}    

Vulcan::~Vulcan()
{
    //std::cout << "Deleting Vulcan...\n";
}

void Vulcan::update()
{   
    /*
    while (angle < 0)
    {
        angle += (int)(MAX_PI * 2);
    }
    
    while ( angle > (int)(MAX_PI * 2) )
    {
        angle -= (int)(MAX_PI * 2);
    }
    */
    
     
    fixed fAngle = itofix(angle);
    
    int newX = 0;
    int newY = 0;
        
    if (this->x < SCREEN_W)
    {
        newX = x + ( speed * fixtoi( fcos(fAngle) ) );
        newY = y + ( speed * fixtoi( fsin(fAngle) ) );
        move(newX, newY);
       
        animation->animate();
    }   
     
}

void Vulcan::move(int x, int y)
{
    this->x = x;
    this->y = y;
}

void Vulcan::draw()
{
    draw_sprite(GameManager::buffer, animation->getCurrentAnimationFrame(), this->x, this->y);    
}
