#include "globals.h"

ViperBeam::ViperBeam()
{
    //std::cout << "Creating ViperBeam object...\n";
}

ViperBeam::ViperBeam(int x, int y, int ammo, int maxAmmo, int fireRate, int wLevel)
{
    this->x = x;
    this->y = y;
    this->ammo = ammo;
    this->maxAmmo = maxAmmo;
    this->fireRate = fireRate;    
    this->waitCount = 0;
    weaponLevel = wLevel;
    hostile = false;
    
    maxMoves = 6;
    
    moves = new int[maxMoves];
    moves[0] = 1;
    moves[1] = 3;
    moves[2] = 5;
    moves[3] = -1;
    moves[4] = -3;
    moves[5] = -5;
    
    moveCount = 0;                    
}    

ViperBeam::~ViperBeam()
{
}

void ViperBeam::dragWeapon(int x, int y)
{    
    this->x = x;
    this->y = y;   
}    

void ViperBeam::fire(int a)
{   
         
    if (waitCount <= 0)
    {
        int pfPoolSize;
        
        switch(weaponLevel)
        {
            case 1:
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(BEAM, a, hostile) );
               
                pfPoolSize= ProjectileFactory::projectilePool.size();
                
                ProjectileFactory::projectilePool[pfPoolSize - 1]->move(x, ( y - moves[moveCount] ) );
                
                waitCount = fireRate;
                
                play_sample( SoundManager::getSample(VIPER_BEAM_FIRE_SFX), 255, 0, 2000, 0);
                
                break;
            case 2:
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(BEAM, a, hostile) );
                ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(BEAM, a, hostile) );
                               
                pfPoolSize= ProjectileFactory::projectilePool.size();
                
                ProjectileFactory::projectilePool[pfPoolSize - 1]->move(x, (y - 15) - moves[moveCount] );
                ProjectileFactory::projectilePool[pfPoolSize - 2]->move(x, (y + 15) + moves[moveCount] );
                
                waitCount = fireRate;
                
                play_sample( SoundManager::getSample(VIPER_BEAM_FIRE_SFX), 255, 0, 2000, 0);
                break;
            case 3:
                if (a == 0)
                {
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(BEAM, 215, hostile) );
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(BEAM, a, hostile) );
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(BEAM, a, hostile) );
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(BEAM, 35, hostile) );                      
                }
                else if (a == 145)
                {
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(BEAM, 160, hostile) );
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(BEAM, a, hostile) );
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(BEAM, a, hostile) );
                    ProjectileFactory::projectilePool.push_back( ProjectileFactory::getProjectile(BEAM, 90, hostile) );                     
                }
                else
                {
                }
                                               
                pfPoolSize= ProjectileFactory::projectilePool.size();
                
                ProjectileFactory::projectilePool[pfPoolSize - 1]->move(x - moves[moveCount], y + 15);
                ProjectileFactory::projectilePool[pfPoolSize - 2]->move(x, (y - 15) - moves[moveCount] );
                ProjectileFactory::projectilePool[pfPoolSize - 3]->move(x, (y + 15) + moves[moveCount] );
                ProjectileFactory::projectilePool[pfPoolSize - 4]->move(x - moves[moveCount], y - 15);                

                
                waitCount = fireRate;
                
                play_sample( SoundManager::getSample(VIPER_BEAM_FIRE_SFX), 255, 0, 2000, 0);
                break;
            default:
                break;
        }    
    
    }
    
    moveCount++;
    
    if (moveCount == 6)
    {
        moveCount = 0;
    }                
}

void ViperBeam::recharge()
{
    --this->waitCount;
}

void ViperBeam::fullCharge()
{
    this->waitCount = 0;
}        

char* ViperBeam::getWeaponName()
{
    return "Viper Beam";
}    
