#include "globals.h"

UpDownFireAction::UpDownFireAction(Sprite* sp, Sprite* t)
{
    s = sp;
    target = t;
    wc = dynamic_cast<WeaponCarrier*>(sp);
    
    maxMoves = 400;
    moveCount = 0;
    
    moves = new int[maxMoves];

    increment = 3;
   
    int i = 0;
   
    for (i = 0; i < 50; i++)
    {
        moves[i] = -(increment);
    }
    
    for (i = i; i < 100; i++)
    {
        moves[i] = 0;
    }
    
    for (i = i; i < 150; i++)
    {
        moves[i] = increment;
    }
    
    for (i = i; i < 200; i++)
    {
        moves[i] = 0;
    }

    for (i = i; i < 250; i++)
    {
        moves[i] = increment;
    }
    
    for (i = i; i < 300; i++)
    {
        moves[i] = 0;
    }

    for (i = i; i < 350; i++)
    {
        moves[i] = -(increment);
    }
    
    for (i = i; i < 400; i++)
    {
        moves[i] = 0;
    }

    fireChance = 0;
    fireDuration = 0;              
}


UpDownFireAction::~UpDownFireAction()
{
}


void UpDownFireAction::performAction()
{
    int targetX = target->x;
    int targetY = target->y;
    int targetH = target->height;
    int sX = s->x;
    int sY = s->y;
    int sH = s->height;
     
    if (s->x > ( SCREEN_W * (.75) ) )
    {
        s->move(s->x - s->speed, s->y);
    }
    else
    {
        if (status != MEDITATING && fireDuration <= 0)
        {
            s->move(s->x, s->y - moves[moveCount]);
            ++moveCount;                   
        }

        fireChance = ( rand() % 10 ) + 1;

        //target is within line of sight
        if ( s->isVisible() && (targetX < sX) && 
             ( ( (targetY + targetH) >= sY) && (targetY <= (sY + sH) ) )
            )
        {
            if (fireChance == 5)
            {
                if (status != MEDITATING)
                {
                    fireDuration  = 100;
                }
                           
                status = MEDITATING;                           
            }                        
        }
        
        if (fireDuration > 0)
        {
            wc->fireWeapon();
            --fireDuration;                         
        }
        else
        {
            status = ALIVE;
        }
        
         

    }    
    
    if (moveCount >= maxMoves)
    {
        moveCount = 0;
    }
    
    wc->getCurrentWeapon()->dragWeapon(s->x - 10, s->y + (s->height / 2) );
    wc->getCurrentWeapon()->recharge();
        
}        
