#include "globals.h"

TitleState::TitleState()
{
    menus = new char*[MAX_MENU];
    menus[2] = "Start";
    menus[1] = "Credits";
    menus[0] = "Quit";
    
    selectDelay = INPUT_DELAY;
}

TitleState::~TitleState()
{
    destroy_bitmap(title);
}

TitleState* TitleState::getInstance()
{
    return new TitleState();
}

void TitleState::init()
{
    title = load_bitmap("graphics/title.bmp", NULL);
    gameOn = true;
    menuNumber = 2;     
}


void TitleState::pause()
{
}


void TitleState::run()
{   
    //play_midi( load_midi("music/stage1.mid"), 1);
     
    while(gameOn) 
    {
        while (GameTimer::game_ticker > 0 && gameOn)
        {
            if (selectDelay != INPUT_DELAY)
            {
                selectDelay++;
            }    
             
            if ( key[KEY_UP] && selectDelay == INPUT_DELAY)
            {
                ++menuNumber;
                
                selectDelay = 0;
                
                if (menuNumber > 2)
                {
                    --menuNumber;
                }
            }

            if ( key[KEY_DOWN] && selectDelay == INPUT_DELAY)
            {
                --menuNumber;
                
                selectDelay = 0;
                
                if (menuNumber < 0)
                {
                    ++menuNumber;
                }
            }
              
            if ( key[KEY_ENTER] )
            {
                switch(menuNumber)
                {
                    case 2:                      
                        GameStateManager::pushState( PlayState::getInstance() );
                        GameStateManager::getCurrentState()->init();//--execute run method
                        GameStateManager::getCurrentState()->run();//--execute run method
                        GameStateManager::popState(); //--pop the element on top                                                           
                        break;
                    case 1:
                        GameStateManager::pushState( CreditState::getInstance() );
                        GameStateManager::getCurrentState()->init();//--execute run method
                        GameStateManager::getCurrentState()->run();//--execute run method
                        GameStateManager::popState(); //--pop the element on top                                                           
                        break;                                                
                    case 0:
                        gameOn = false;
                        break;
                    default:
                        break;
                }
            }

            //menuName = (menus[menuNumber].c_str);

            //control game speed
            GameTimer::game_ticker--;   

            draw_sprite(GameManager::buffer, title, 0, 0);
                          
            //textprintf_centre_ex(GameManager::buffer, font, SCREEN_W/2, 250, makecol(255, 255, 255), (*menuName));                         
            textprintf_centre_ex(GameManager::buffer, font, SCREEN_W/2, SCREEN_H/2, makecol(255, 255, 255), makecol(0, 0, 0), "%s", menus[menuNumber]);
            //blit buffer
            GameManager::blitBuffer();
        }           
    } 
        
}


void TitleState::update()
{
}


void TitleState::clean()   
{
}


TitleState* TitleState::instance;
