#ifndef _SWIRL_H_
#define _SWIRL_H_

class Swirl : public Enemy, public WeaponCarrier
{
    private:        
        Weapon* currentWeapon;
        std::map<WeaponTypes, Weapon*> weaponBlueprints;
    public:
        Swirl(int x, int y, int w, int h, int sp, Status stat, int lfe, int rRate);
        virtual ~Swirl();
    public:
        virtual void update();
        virtual void move(int x, int y);
        virtual void draw();
        
        virtual void addWeapon(WeaponTypes weaponType, Weapon* weapon);
        virtual void setCurrentWeapon(WeaponTypes weaponType);
        virtual Weapon* getCurrentWeapon();
        virtual void fullChargeWeapon();
        virtual void fireWeapon();
        virtual void upgradeWeapon();               
};    

#endif
