#include "globals.h"

Swirl::Swirl(int x, int y, int w, int h, int sp, Status stat, int lfe, int rRate)
{
    this->x = x;
    this->y = y;
    width = w;
    height = h;
    speed = sp;
    status = stat;
    life = lfe;    

    recoveryRate = rRate;
    recoveryTime = 0;

    screamed = false;

    direction = LEFT;

    normalStateAnimation = new Animation(BitmapManager::getBitmap(SWIRL_SPRITE_FLYING),  10, 4, BY_WIDTH);
    hitStateAnimation = new Animation(BitmapManager::getBitmap(SWIRL_SPRITE_HIT),  10, 4, BY_WIDTH);
    dyingStateAnimation = new Animation(BitmapManager::getBitmap(SPRITE_EXPLOSION),  10, 4, BY_WIDTH);
    currentAnimation = normalStateAnimation;
    
    addWeapon(VULCAN_GUN, WeaponFactory::getWeapon(VULCAN_GUN) );
    //addWeapon(VULCAN_GUN, WeaponFactory::getWeapon(VIPER_BEAM) );
    setCurrentWeapon(VULCAN_GUN);
}

Swirl::~Swirl()
{
    //std::cout << "destroying Swirl...\n";
}

void Swirl::update()
{
    if (status == DYING)
    {
        if (screamed == false)
        {
            play_sample( SoundManager::getSample(METEOR_DESTROYED_SFX), 255, 0, 2000, 0);
            screamed = true;                                    
        }       
               
        currentAnimation = dyingStateAnimation;
        
        if ( currentAnimation->isLastAnimationFrame() )
        {
            status = DEAD;
        }
    }     
    
    if (status != DEAD)
    {
        currentAnimation->animate();

        int currentAnimationFrame = currentAnimation->getCurrentAnimationFrameNumber();

        if ( isRecovering() )
        {
             currentAnimation = hitStateAnimation;
             currentAnimation->setCurrentAnimationFrameNumber(currentAnimationFrame);
        }
        else
        {
            if ( status != DYING )
            {
                currentAnimation = normalStateAnimation;
                currentAnimation->setCurrentAnimationFrameNumber(currentAnimationFrame);
            }            
        }

    }

    recover();

    //perform action
    if (currentAction != NULL && status != DYING && status != DEAD )
    {
        currentAction->performAction();
    }    
    
}

void Swirl::move(int x, int y)
{
    this->x = x;
    this->y = y;
}

void Swirl::draw()
{
    draw_sprite(GameManager::buffer, currentAnimation->getCurrentAnimationFrame(), x, y);
}    

void Swirl::addWeapon(WeaponTypes weaponType, Weapon* weapon)
{
     //add weapon to std::map
     weapon->setHostile(true);
     weaponBlueprints.insert( std::pair<WeaponTypes, Weapon*>(weaponType, weapon) );
}    

void Swirl::fullChargeWeapon()
{
    currentWeapon->fullCharge();
}    

void Swirl::setCurrentWeapon(WeaponTypes weaponType)
{
     currentWeapon = weaponBlueprints[weaponType];
     
     currentWeapon->dragWeapon(x + width, y);
}

Weapon* Swirl::getCurrentWeapon()
{
    return currentWeapon;
}  

void Swirl::fireWeapon()
{
     if (currentWeapon != NULL)
     {
         switch (direction)
         {
             case LEFT:
                  currentWeapon->fire(145);
                  break;
             case RIGHT:
                  currentWeapon->fire(0);
                  break;
             default:
                  break;       
         }                       
     }
}

void Swirl::upgradeWeapon()
{
    currentWeapon->incrementWeaponLevel();
}
