#ifndef _SPRITE_H_
#define _SPRITE_H_

class Sprite
{
    public:
        int x;
        int y;
        int width;
        int height;
        int speed;
    protected:
        Status status;
        Direction direction;
        BITMAP* bitmap;
        Animation* currentAnimation;
    public:
        virtual ~Sprite();
    public:
        virtual int getX();
        virtual int getY();  
        virtual int getSpeed();      
        virtual void update() = 0;
        virtual void move(int dx, int dy) = 0;          
        virtual void draw() = 0;
        virtual bool intersects(int x, int y, int w, int h);
        virtual bool collides(Sprite* sprite);
        
        virtual bool setStatus(Status s);
        virtual bool isVisible();
        virtual bool isAlive();
        virtual bool isDead();
        virtual bool isRetreating();
};    

#endif
