#include "globals.h"

Sprite::~Sprite()
{
    //std::cout << "Deleting Sprite...\n";                 
}

int Sprite::getX()
{
    return this->x;
}

int Sprite::getY()
{
    return this->y;
}

int Sprite::getSpeed()
{
    return this->speed;
}            
     

bool Sprite::intersects(int x, int y, int w, int h)
{
  return (x <= this->x + width) && (x + w >= this->x) && 
         (y <= this->y + height) && (y + h >= this->y);     
}

bool Sprite::collides(Sprite* sprite)
{
  int x = sprite->x;
  int y = sprite->y;
  int w = sprite->width;
  int h = sprite->height;
     
  return (x <= this->x + width) && (x + w >= this->x) && 
         (y <= this->y + height) && (y + h >= this->y);
}

bool Sprite::setStatus(Status s)
{
    status = s;
}    

bool Sprite::isVisible()
{
    return (x < SCREEN_W && x > 0 && y < SCREEN_H && y > 0);
}

bool Sprite::isAlive()
{
    return (status == ALIVE);
}

bool Sprite::isDead()
{
    return (status == DEAD);
}  

bool Sprite::isRetreating()
{
    return (status == RETREATING);
}       
