#ifndef _SOUNDMANAGER_H_
#define _SOUNDMANAGER_H_

class SoundManager
{
    private:
        static std::map<SoundKeys, SAMPLE*> sampleTable;
        static std::map<MIDIKeys, MIDI*> midiTable;
    private:
        SoundManager();
    public:
        ~SoundManager();
    public:
        static SAMPLE* addSample(SoundKeys key, SAMPLE* sample);
        static SAMPLE* addSample(SoundKeys key, char* fileName);
        static SAMPLE* getSample(SoundKeys key);
        static bool lookupSample(SoundKeys key);
        static void removeSample(SoundKeys key);
        static void removeAllSample();

        static MIDI* addMIDI(MIDIKeys key, MIDI* midi);
        static MIDI* addMIDI(MIDIKeys key, char* fileName);
        static MIDI* getMIDI(MIDIKeys key);
        static bool lookupMIDI(MIDIKeys key);
        static void removeMIDI(MIDIKeys key);
        static void removeAllMIDI();

};    

#endif
