#include "globals.h"

SoundManager::SoundManager()
{
    //can never be instantiated outside the class!!!
}

SoundManager::~SoundManager()
{
}        

/*Samples Section*/

SAMPLE* SoundManager::addSample(SoundKeys key, SAMPLE* sample)
{
    sampleTable.insert( std::pair<SoundKeys, SAMPLE*>(key, sample) );
    
    return sampleTable[key];
}

SAMPLE* SoundManager::addSample(SoundKeys key, char* fileName)
{
    SAMPLE* sample = load_sample(fileName);

    sampleTable.insert( std::pair<SoundKeys, SAMPLE*>(key, sample) );
    
    return sample;
}

SAMPLE* SoundManager::getSample(SoundKeys key)
{
    return sampleTable[key];
}

bool SoundManager::lookupSample(SoundKeys key)
{
    return ( sampleTable.find(key) != sampleTable.end() );
}

void SoundManager::removeSample(SoundKeys key)
{
    std::map<SoundKeys, SAMPLE*>::iterator it = sampleTable.find(key);
    
    SAMPLE* sample = it->second;
    
    if ( it != sampleTable.end() )
    {
         sampleTable.erase(it);
         destroy_sample(sample);
    }
}

void SoundManager::removeAllSample()
{
     std::map<SoundKeys, SAMPLE*>().swap(sampleTable);
}

/*MIDI Section*/

MIDI* SoundManager::addMIDI(MIDIKeys key, MIDI* midi)
{
    midiTable.insert( std::pair<MIDIKeys, MIDI*>(key, midi) );
    
    return midiTable[key];
}

MIDI* SoundManager::addMIDI(MIDIKeys key, char* fileName)
{
    MIDI* midi = load_midi(fileName);

    if (!midi)
    {
      allegro_message("Error reading MIDI file '%s'\n", fileName);
    }

    midiTable.insert( std::pair<MIDIKeys, MIDI*>(key, midi) );
    
    return midi;
}

MIDI* SoundManager::getMIDI(MIDIKeys key)
{
    return midiTable[key];
}

bool SoundManager::lookupMIDI(MIDIKeys key)
{
    return ( midiTable.find(key) != midiTable.end() );
}

void SoundManager::removeMIDI(MIDIKeys key)
{
    std::map<MIDIKeys, MIDI*>::iterator it = midiTable.find(key);
    
    MIDI* MIDI = it->second;
    
    if ( it != midiTable.end() )
    {
         midiTable.erase(it);
         destroy_midi(MIDI);
    }
}

void SoundManager::removeAllMIDI()
{
     std::map<MIDIKeys, MIDI*>().swap(midiTable);
}


std::map<SoundKeys, SAMPLE*> SoundManager::sampleTable;
std::map<MIDIKeys, MIDI*> SoundManager::midiTable;
