#ifndef _SHIP_H_
#define _SHIP_H_

class Ship : public Sprite, public WeaponCarrier
{
    protected:
        int life;
        int recoveryTime;
        int recoveryRate;    
        Weapon* currentWeapon;
        std::map<WeaponTypes, Weapon*> weaponBlueprints;
        
        Animation* normalStateAnimation;
        Animation* dyingAnimation;
    public:
        Ship(int x, int y, int w, int h, int speed, int recoveryRate, int recoveryTime, Status stat, int lfe); //: bitmap(*bitmap), x(x), y(x), width(w), height(h){}        
        virtual ~Ship();
    public:           
        virtual void update();
        virtual void move(int dx, int dy);    
        virtual void draw(); 
        
        virtual bool collides(Sprite* sprite);
        
        void setLife(int value);
        int getLife();
        void takeDamage(int damagePoint);
        
        bool isRecovering();
        
        virtual void addWeapon(WeaponTypes weaponType, Weapon* weapon);
        virtual void setCurrentWeapon(WeaponTypes weaponType);
        virtual Weapon* getCurrentWeapon();
        virtual void Ship::fullChargeWeapon();
        virtual void fireWeapon();
        virtual void upgradeWeapon();
        
        void recover();
};    

#endif
