#include "globals.h"

Ship::Ship(int x, int y, int w, int h, int speed, int recoveryRate, int recoveryTime, Status stat, int lfe)
{    
    this->bitmap = bitmap;
    this->x = x;
    this->y = y;
    width = w;
    height = h;
    this->speed = speed;
    this->recoveryRate = recoveryRate;
    this->recoveryTime = recoveryTime;
    status = stat;
    life = lfe;
    
    normalStateAnimation = new Animation(BitmapManager::getBitmap(SHIP_SPRITE), 10, 4, BY_WIDTH);
    currentAnimation = normalStateAnimation;
}

Ship::~Ship()
{
    //delete animation;
}

void Ship::update()
{
    currentAnimation->animate();
    currentWeapon->dragWeapon(x + width, y + (height/2) );
    currentWeapon->recharge();
    recover();
}
        
void Ship::move(int dx, int dy)
{
    x = dx;
    y = dy;
}    
             
void Ship::draw()
{    
     if (recoveryTime % 2 == 0)
     {
         draw_sprite(GameManager::buffer, currentAnimation->getCurrentAnimationFrame(), x, y);
     }
}            

bool Ship::collides(Sprite* sprite)
{
  int x = sprite->x;
  int y = sprite->y;
  int w = sprite->width;
  int h = sprite->height;   
  
  int hitAllowance = 20;
     
  return (x <= this->x + width) && (x + w >= this->x) && 
         (y <= this->y + height) && (y + h >= (this->y + hitAllowance) );
}

void Ship::setLife(int value)
{
    life = value;
}

int Ship::getLife()
{
    return life;
}

void Ship::takeDamage(int damagePoint)
{
    life -= damagePoint;
    recoveryTime = MAX_RECOVERY_TIME;
}

void Ship::addWeapon(WeaponTypes weaponType, Weapon* weapon)
{
     //add weapon to std::map
     weapon->setHostile(false);
     weaponBlueprints.insert( std::pair<WeaponTypes, Weapon*>(weaponType, weapon) );
}    

void Ship::fullChargeWeapon()
{
    currentWeapon->fullCharge();
}    

void Ship::setCurrentWeapon(WeaponTypes weaponType)
{
     currentWeapon = weaponBlueprints[weaponType];
     
     currentWeapon->dragWeapon(x + width, y);
}

Weapon* Ship::getCurrentWeapon()
{
    return currentWeapon;
}    

void Ship::fireWeapon()
{
     if (currentWeapon != NULL)
     {
         currentWeapon->fire(0);                       
     }
}

void Ship::upgradeWeapon()
{
    currentWeapon->incrementWeaponLevel();
}    

void Ship::recover()
{
    if (recoveryTime > 0)
    {
        recoveryTime -= recoveryRate;
        
        if (recoveryTime < 0)
        {
            recoveryTime = 0;
        }    
    }    
}

bool Ship::isRecovering()
{
    return (recoveryTime > 0);
}            
