#include "globals.h"

ProjectileFactory::ProjectileFactory()
{
    //can never be instantiated outside the class!!!
}

ProjectileFactory::~ProjectileFactory()
{
    std::vector<Projectile*>().swap(projectilePool);
}


Projectile* ProjectileFactory::getProjectile(ProjectileTypes projectileType, int angle, bool hostile)
{
    BITMAP* bitmap = NULL;
    
    switch(projectileType)
    {
        case VULCAN:
             //Vulcan(int x, int y, int w, int h, int speed, int p, bool active, bool fired);
            bitmap = BitmapManager::getBitmap(VULCAN_SPRITE);                
            return new Vulcan(0, 0, (bitmap->w / 4), bitmap->h, 5, 5, true, true, angle, hostile);
        case BEAM:
            bitmap = BitmapManager::getBitmap(BEAM_SPRITE);                
            return new Beam(0, 0, (bitmap->w / 4), bitmap->h, 7, 1, true, true, angle, hostile);
        default:
            return NULL;  
    }    
}

std::vector<Projectile*> ProjectileFactory::projectilePool;
