#include "globals.h"

PowerUp::PowerUp(int x, int y, int h, int w, int sp, bool active)
{
    this->x = x;
    this->y = y;
    height = h;
    width = w;
    speed = sp;
    this->active = active;
    
    animation = new Animation(BitmapManager::getBitmap(POWER_UP),  10, 4, BY_WIDTH);
    
    currentAnimation = animation;
}

PowerUp::~PowerUp()
{
    delete animation;
}        

void PowerUp::update()
{
    currentAnimation->animate();
    move(x - speed, y);
}
        
void PowerUp::move(int dx, int dy)
{
    x = dx;
    y = dy;
}    
             
void PowerUp::draw()
{    
    draw_sprite(GameManager::buffer, currentAnimation->getCurrentAnimationFrame(), x, y); 
}

bool PowerUp::isActive()
{
    return active;
}
    
void PowerUp::makeInactive()
{
    active = false;
}    

std::vector<PowerUp*> PowerUp::powerUpPool;
