#ifndef _PLAYSTATE_H_
#define _PLAYSTATE_H_

class PlayState : public GameState
{
    private:
        static PlayState* instance;
        static int currentLevel; 
                       
        //game elements
        GameBackground* bg;
        MIDI* stageMusic;
        Boss* stageBoss;        
                
        int xToTravel;
        int xTravelled;
    public:
        static Ship* ship;
    private:
        PlayState();
    public:
        virtual ~PlayState();
    private:
        void drawLifeBar(int x, int y, int length, int height, BITMAP* bitmap);              
    public:
        void loadLevel(int level);
        void createLevel(PACKFILE* packFile);
        void createProps(PACKFILE* packFile);
        void unloadLevel(int level);             
        
        static PlayState* getInstance(); 
        virtual void init();
        virtual void pause();
        virtual void run();
        virtual void update();
        virtual void clean();         
};    

#endif
