#include "globals.h"

PlayState::PlayState()
{
}    

PlayState::~PlayState()
{
    //unloadLevel(currentLevel);                    
                       
    BitmapManager::removeAll();
    SoundManager::removeAllSample();
    SoundManager::removeAllMIDI();
    
    delete ship;
}

PlayState* PlayState::getInstance()
{
    instance = new PlayState();
    
    return instance;    
}    

void PlayState::init()
{
    currentLevel = 1;

    GameManager::game_score = 0;
    
    //load sprites
    BitmapManager::addBitmap(SHIP_SPRITE, "graphics/fs.bmp");
    BitmapManager::addBitmap(VULCAN_SPRITE, "graphics/vulcan.bmp");
    BitmapManager::addBitmap(BEAM_SPRITE, "graphics/beam.bmp");
    BitmapManager::addBitmap(ASTEROID_SPRITE_FLYING, "graphics/asteroid_flying.bmp");    
    BitmapManager::addBitmap(ASTEROID_SPRITE_HIT, "graphics/asteroid_hit.bmp"); 
    BitmapManager::addBitmap(ASTEROID_SPRITE_DYING, "graphics/asteroid_destroyed.bmp");
    BitmapManager::addBitmap(BULLET_HEAD_SPRITE_FLYING, "graphics/bullet_head_flying.bmp");
    BitmapManager::addBitmap(BULLET_HEAD_SPRITE_HIT, "graphics/bullet_head_hit.bmp");
    BitmapManager::addBitmap(SPRITE_EXPLOSION, "graphics/explosion.bmp");
    BitmapManager::addBitmap(SWIRL_SPRITE_FLYING, "graphics/swirl_flying.bmp");    
    BitmapManager::addBitmap(SWIRL_SPRITE_HIT, "graphics/swirl_hit.bmp"); 
    //BitmapManager::addBitmap(SWIRL_SPRITE_DYING, "graphics/swirl_destroyed.bmp");
    BitmapManager::addBitmap(BOSS1_SPRITE_NORMAL, "graphics/boss1_normal.bmp");        
    BitmapManager::addBitmap(BOSS1_SPRITE_HIT, "graphics/boss1_hit.bmp");
    BitmapManager::addBitmap(BOSS1_SPRITE_DYING, "graphics/boss1_dying.bmp");
    BitmapManager::addBitmap(POWER_UP, "graphics/power_up.bmp");
    
    //background prop sprites
    BitmapManager::addBitmap(SPACE_JUNKS_PROP, "graphics/spacejunks.bmp");    
    
    //load SFX
    SoundManager::addSample(METEOR_DESTROYED_SFX, "sfx/meteordestroyed.wav");
    SoundManager::addSample(VULCAN_GUN_FIRE_SFX, "sfx/vulcan.wav");
    SoundManager::addSample(VIPER_BEAM_FIRE_SFX, "sfx/beam.wav");
    SoundManager::addSample(POWER_UP_SFX, "sfx/power_up.wav");
    
    //load music
    SoundManager::addMIDI(STAGE1_MIDI, "music/stage1.mid");
    SoundManager::addMIDI(STAGE1_BOSS_MIDI, "music/boss1.mid");
    
    //ship = new Ship(BitmapManager::SHIP_SPRITE, 50, 50, 50, 32, 1);
    //Ship(int x, int y, int w, int h, int speed, int recoveryRate, int recoveryTime, Status stat, int lfe);

    ship = new Ship(50, 50, 50, 40, 3, MAX_RECOVERY_RATE, MAX_RECOVERY_TIME, ALIVE, MAX_PLAYER_LIFE);
    
    //add a weapon for the ship
    ship->addWeapon(VULCAN_GUN, WeaponFactory::getWeapon(VULCAN_GUN) );
    ship->setCurrentWeapon(VULCAN_GUN);
    //ship->addWeapon(VIPER_BEAM, WeaponFactory::getWeapon(VIPER_BEAM) );
    //ship->setCurrentWeapon(VIPER_BEAM);    
    ship->move(0, (SCREEN_H / 2) );
}

void PlayState::pause()
{
}

void PlayState::run()
{                  
    loadLevel(currentLevel);
    play_midi(stageMusic, 0);
  
    //begin main game loop
    while ( !key[KEY_ESC] )
    {   
        
        while (GameTimer::game_ticker > 0)
        {
            //move left
            if ( key[KEY_A] )
            {
                ship->move( ship->x - ship->getSpeed(), ship->y );
                if ( ship->x <= 0 )
                {
                    ship->move( ship->x + ship->getSpeed(), ship->y ); 
                }
            }    
            //move down
            if ( key[KEY_S] )
            {
                ship->move( ship->x, ship->y + ship->getSpeed() );
            
                if ( (ship->y + ship->height) >= SCREEN_H )
                {
                    ship->move( ship->x, ship->y - ship->getSpeed() );
                }
            }    
            //move right
            if ( key[KEY_D] )
            {
                ship->move( ship->x + ship->getSpeed(), ship->y );
                
                if ( (ship->x + ship->width) >= SCREEN_W )
                {
                     ship->move( ship->x - ship->getSpeed(), ship->y );
                }
            }    
            //move up
            if ( key[KEY_W] )
            {
                ship->move( ship->x, ship->y - ship->getSpeed() );
                
                if ( ship->y <= 20 )
                {
                    ship->move( ship->x, ship->y + ship->getSpeed() );     
                }
            }
            //fire weapon
            if ( key[KEY_K] )
            {
                ship->fireWeapon();
            }
            //change weapon
            if ( key[KEY_TAB] )
            {
                 //ship->fireWeapon();
            }
            //fire special
            if ( key[KEY_L] )
            {
            }
            
            //exit to menu
            if ( key[KEY_ESC] )
            {
                break;
            }    
            
            //scroll the background
            bg->update();
            bg->draw();  
         
            //animate the ship
            ship->update();
            
            //move all background props
            for (std::vector<BackgroundProp*>::iterator it = PropFactory::propPool.begin(); it != PropFactory::propPool.end(); ++it)
            {
                BackgroundProp* bp = (*it);
                
                bp->update();
                bp->draw();  
                    
                bp = NULL;
            }   

  
            //move all powerups
            for (std::vector<PowerUp*>::iterator it = PowerUp::powerUpPool.begin(); it != PowerUp::powerUpPool.end(); ++it)
            {
                PowerUp* pUp = (*it);
                
                if ( pUp->isActive() )
                {
                    pUp->update();
                    pUp->draw();
                    
                    if ( ship->collides(pUp) )
                    {
                        pUp->makeInactive();
                        ship->upgradeWeapon();
                        play_sample( SoundManager::getSample(POWER_UP_SFX), 255, 0, 2000, 0);
                    }
                }    
                    
                pUp = NULL;
            }    

            //move all enemies
            for(std::vector<Enemy*>::iterator it = EnemyFactory::enemyPool.begin(); it != EnemyFactory::enemyPool.end(); ++it)
            {
                Enemy* e = *it;
                
                //enemy is alive or dying
                if ( !( e->isDead() ) || e->isDying() )
                {
                    e->update();
                    e->draw();
                    
                    //enemy is alive, ship is not recovering and ship hits enemy
                    if ( !( e->isDead() ) && !( ship->isRecovering() ) && ship->collides(e) )
                    {
                        ship->takeDamage(10); //TODO: change to enemy attack power
                        e->takeDamage(1);
                    }                     
                }
                
                if (e->x < (0 - SCREEN_W) )
                {
                    it = EnemyFactory::enemyPool.erase(it);
                    // we must decrement, because it will be incremented when the loop starts over again
                    --it;
                    delete e;                         
                }
                
                e = NULL;
            }            
   
            //move all projectiles
            for (std::vector<Projectile*>::iterator it = ProjectileFactory::projectilePool.begin(); it != ProjectileFactory::projectilePool.end(); ++it)
            {                   
                                 
                if ( (*it)->isVisible() == true && (*it)->isActive() )
                {
                    Projectile* p = *it;
                    p->update(); //(*it)->update();
                    p->draw(); //(*it)->draw();
                    
                    
                    if ( p->isHostile() && !( ship->isRecovering() ) )
                    {
                       /* check if ship collides projectile instead of
                          projectile collides ship because ship provides
                          a more precise collision that a player would not
                          get annoyed with
                       */
                       if ( ship->collides(p) )
                       {
                         ship->takeDamage( p->getPower() );
                         p->makeInactive();
                       }
                    }                    
                    
                    //check if projectile collides with the boss
                    if ( stageBoss->collides(p) && p->isActive() && !( p->isHostile() ) && !( stageBoss->isDead() ) && !( stageBoss->isDying() ) )
                    {
                        stageBoss->takeDamage( p->getPower() );
                        p->makeInactive();

                             //player killed the boss                             
                             if ( !( stageBoss->isAlive() ) )
                             {
                                 GameManager::game_score += 1000;                                  
                             }
                                                               
                    }
                    
                    //check for collision on bullet and enemies
                    for(std::vector<Enemy*>::iterator eit = EnemyFactory::enemyPool.begin(); eit != EnemyFactory::enemyPool.end(); ++eit)
                    {                              
                        Enemy* e = *eit; 
                        
                        //projectile hits an enemy
                        if ( p->collides(e) && p->isActive() && !( p->isHostile() ) && !( e->isDead() ) && !( e->isDying() ) )
                        {
                             e->takeDamage( p->getPower() );
                             p->makeInactive();

                             //player killed the enemy                             
                             if ( !( e->isAlive() ) )
                             {
                                 GameManager::game_score += 10;                                  
                             }
                             
                             //exit the inner loop
                             break;
                        }
                    }                    
                    
                }
                else
                { 
                    Projectile* p = *it;
                    it = ProjectileFactory::projectilePool.erase(it);
                    // we must decrement, because it will be incremented when the loop starts over again
                    --it;
                    delete p;
                }  
            }
            
            //check if player collides with the boss
            if ( !( stageBoss->isDead() ) && !( ship->isRecovering() ) && stageBoss->collides(ship) )
            {
                ship->takeDamage(30); //TODO: change to enemy attack power
            }
            
            ship->draw();
            
            if ( !stageBoss->isDead() )
            {
                stageBoss->update();
                stageBoss->draw();                 
            }
            
            xTravelled++;            
                
            //control game speed
            GameTimer::game_ticker--;                                   
            
            
            rectfill(GameManager::buffer, 0, 0, SCREEN_W, 25, 0);
            textout_ex(GameManager::buffer, font, "Life: ", 10, 10, makecol(0, 0, 255), -1);
            //drawLifeBar(int x, int y, int length, height, BITMAP* bitmap); 
            drawLifeBar(50, 0, ship->getLife() , 20, GameManager::buffer);
            
            textprintf_centre_ex(GameManager::buffer, font, SCREEN_W/2, 10, makecol(255, 255, 255), makecol(0, 0, 0), "Current Weapon: %s", ship->getCurrentWeapon()->getWeaponName() );                      
            textprintf_centre_ex(GameManager::buffer, font, (SCREEN_W - (SCREEN_W/8) ), 10, makecol(255, 255, 255), makecol(0, 0, 0), "Score: %d", GameManager::game_score);                      
            
            textprintf_centre_ex(GameManager::buffer, font, SCREEN_W/2, 176, makecol(255, 255, 255), makecol(0, 0, 0), "num=%d", GameTimer::game_ticker);

            //page flip
            //GameManager::flipPage();
        
            //blit buffer
            GameManager::blitBuffer();                      
        }    
                          
    }
    
    unloadLevel(currentLevel);    
}

void PlayState::update()
{
}

void PlayState::clean()
{
}                        

void PlayState::loadLevel(int level)
{     
    PACKFILE* levelMap;
    PACKFILE* propMap;
    
    switch(level)
    {
        case 1:
            xToTravel = 6000;
            xTravelled = 0;                          
            levelMap = pack_fopen("levels/level_01.lvl", "r");            
            propMap = pack_fopen("levels/props_01.fsp", "r");            

            createLevel(levelMap);
            createProps(propMap);

            bg = new GameBackground(BitmapManager::addBitmap(SPACE_BACKGROUND, "graphics/bg.bmp"), HORIZONTAL_LEFT, 1, SCREEN_W, SCREEN_H);

            stageMusic = SoundManager::getMIDI(STAGE1_MIDI);
            
            //Cyclops(int x, int y, int w, int h, int sp, Status stat, int lfe, int rRate);
            stageBoss = new Cyclops(xToTravel, (SCREEN_H / 2), 50, 50, 1, ALIVE, 1000, MAX_ENEMY_RECOVERY_RATE);
            stageBoss->setAction( new UpDownFireAction(stageBoss, ship) );
            break;
        default:
            break;        
    }
    
    if (levelMap)
    {
        pack_fclose(levelMap);
    }
    
    if (propMap)
    {
        pack_fclose(propMap);
    }                    
}

void PlayState::createLevel(PACKFILE* packFile)
{
    std::string line;
    char buf[512];
    
    int currX = 0;
    int currY = 0;
    int xIncrement = (SCREEN_W / 20);
    int yIncrement = (SCREEN_H / 20);     
     
    if (!packFile)
    {
        allegro_message("COULD NOT CREATE LEVEL!: %s", allegro_error);
    }    
            
    while ( pack_feof(packFile) == 0 )
    {
        //read a line from the file (levelMap)
        line = pack_fgets(buf, sizeof(buf), packFile);
                
        //loop through each character in the line
        for (int i = 0; i < line.length(); i++)
        {                           
            //only an empty space
            if ( line.at(i) == ' ')
            {
                currX += xIncrement;    
            }
            else if( line.at(i) == 'P' )
            {                
                PowerUp* pUp = new PowerUp(currX, currY, 32, 32, 2, true);
                
                PowerUp::powerUpPool.push_back(pUp);
            
                pUp = NULL;
            
                currX += xIncrement;
            }    
            else //create an enemy object
            {
                Enemy* e = EnemyFactory::getEnemy( line.at(i) );
                //set initial position of the enemy
                e->move(currX, currY);
                
                EnemyFactory::enemyPool.push_back(e);
                        
                e = NULL;
                        
                currX += xIncrement;
            }        
        }
        
        currX = 0;
        currY += yIncrement;    
    }              
}

void PlayState::unloadLevel(int level)
{
    switch(level)
    {
        case 1:
            stop_midi();
            std::vector<Enemy*>().swap(EnemyFactory::enemyPool);
            std::vector<Projectile*>().swap(ProjectileFactory::projectilePool);
            std::vector<PowerUp*>().swap(PowerUp::powerUpPool);
            std::vector<BackgroundProp*>().swap(PropFactory::propPool);
            delete bg;
            delete stageBoss;
            break;
        default:
            break;
    }    
}

void PlayState::createProps(PACKFILE* packFile)
{
    std::string line;
    char buf[255];
    
    int currX = 0;
    int currY = 0;
    int xIncrement = (SCREEN_W / 20);
    int yIncrement = (SCREEN_H / 20);     
     
    if (!packFile)
    {
        allegro_message("COULD NOT CREATE PROPS!: %s", allegro_error);
    }    
            
    while ( pack_feof(packFile) == 0 )
    {
        //read a line from the file (levelMap)
        line = pack_fgets(buf, sizeof(buf), packFile);
                
        //loop through each character in the line
        for (int i = 0; i < line.length(); i++)
        {                           
            //only an empty space
            if ( line.at(i) == ' ')
            {
                currX += xIncrement;    
            }    
            else //create an enemy object
            {                       
                BackgroundProp* bp = PropFactory::getProp( line.at(i) );
                bp->move(currX, currY);
                
                PropFactory::propPool.push_back(bp); 
                
                bp = NULL;
                
                currX += xIncrement;
            }        
        }
        
        currX = 0;
        currY += yIncrement;    
    }              
}


void PlayState::drawLifeBar(int x, int y, int length, int height, BITMAP* bitmap)
{
    //rectfill(BITMAP *bmp, int x1, int y1, int x2, int y2, int color);
    if (length <= 0)
    {
        length = 0;
    }
    
    rectfill(bitmap, x, y, (x + length), height, 255);
}    

PlayState* PlayState::instance;
int PlayState::currentLevel;
Ship* PlayState::ship;
