#ifndef _GLOBALS_H_
#define _GLOBALS_H_

enum Status
{
    ALIVE,
    HIT,
    MEDITATING, 
    RETREATING,
    DYING,
    RECOVERING, 
    DEAD
};

enum Direction
{
     UP,
     DOWN,
     LEFT,
     RIGHT
};

enum ProjectileTypes
{
     VULCAN, 
     BEAM, 
     MISSILE
};

enum WeaponTypes
{
     VULCAN_GUN, 
     VIPER_BEAM, 
     MISSILE_LAUNCHER
};

//for animation frame extraction
enum FrameExtractionMethods
{
    BY_WIDTH, 
    BY_HEIGHT
};    

//bitmap keys
enum BitmapKeys
{
    TITLE,
    SHIP_SPRITE,
    VULCAN_SPRITE,
    BEAM_SPRITE,
    ASTEROID_SPRITE_FLYING,
    ASTEROID_SPRITE_HIT,
    ASTEROID_SPRITE_DYING,
    BULLET_HEAD_SPRITE_FLYING,
    BULLET_HEAD_SPRITE_HIT,
    SPRITE_EXPLOSION,
    SWIRL_SPRITE_FLYING,
    SWIRL_SPRITE_HIT,
    SWIRL_SPRITE_DYING,
    BOSS1_SPRITE_NORMAL,    
    BOSS1_SPRITE_HIT,
    BOSS1_SPRITE_DYING,
    POWER_UP,
    SPACE_JUNKS_PROP,
    SPACE_BACKGROUND,
};

enum SoundKeys
{
    VULCAN_GUN_FIRE_SFX,
    VIPER_BEAM_FIRE_SFX,
    METEOR_DESTROYED_SFX,
    POWER_UP_SFX
};

enum MIDIKeys
{
    STAGE1_MIDI,
    STAGE2_MIDI,
    STAGE1_BOSS_MIDI,
    GAMEOVER_MIDI,
    TITLE_MIDI
};

enum BackgroundScrollType
{
    HORIZONTAL_LEFT, 
    HORIZONTAL_RIGHT, 
    VERTICAL_UP, 
    VERTICAL_DOWN 
};

//|-----------------------------------------------------------------
//|Math constants
//|-----------------------------------------------------------------
#define MAX_PI 3.1416

//|-----------------------------------------------------------------
//|Default player stats
//|-----------------------------------------------------------------
#define MAX_PLAYER_LIFE 150
#define MAX_PLAYER_RES 5
#define MAX_RECOVERY_TIME 1000
#define MAX_RECOVERY_RATE 15 //should be an odd number

//|-----------------------------------------------------------------
//|Default weapon stats
//|-----------------------------------------------------------------
#define MIN_WEAPON_LEVEL 1
#define MAX_WEAPON_LEVEL 3

//|-----------------------------------------------------------------
//|Default enemy stats
//|-----------------------------------------------------------------
#define MAX_ENEMY_RECOVERY_TIME 2
#define MAX_ENEMY_RECOVERY_RATE 1

//|-----------------------------------------------------------------
//|Credits section and Title section stuff
//|-----------------------------------------------------------------
#define INPUT_DELAY 15
#define MAX_MENU 3
#define MAX_TEAM_SIZE 4


//|-----------------------------------------------------------------
//|C/C++ specific headers
//|-----------------------------------------------------------------

//#include <iostream>
#include<cstdio>

//|-----------------------------------------------------------------
//|Includes for std templates
//|-----------------------------------------------------------------
#include <map>
#include <vector>
#include <stack>
#include <string>


//|-----------------------------------------------------------------
//|Includes for Allegro
//|-----------------------------------------------------------------

#include <allegro.h>


//|-----------------------------------------------------------------
//|Includes for class files
//|-----------------------------------------------------------------

#include "bitmapmanager.hpp"
#include "soundmanager.hpp"

#include "gamemanager.hpp"
#include "gametimer.hpp"

#include "animation.hpp"

//weapon headers
#include "weapon.hpp"
#include "vulcangun.hpp" 
#include "viperbeam.hpp"
#include "weaponfactory.hpp"

//sprite(superclass)
#include "sprite.hpp"

//traits
#include "weaponcarrier.hpp"

//Actions
#include "action.hpp"
#include "predefinedattackaction.hpp"
#include "attackretreataction.hpp"
#include "updownfireaction.hpp"

//PLAYER SHIP
#include "ship.hpp"

#include "gamebackground.hpp"

//background props
#include "backgroundprop.hpp"
#include "propfactory.hpp"

//enemy headers
#include "enemy.hpp"
#include "asteroid.hpp"
#include "bullethead.hpp"
#include "swirl.hpp"
#include "enemyfactory.hpp"

//boss headers
#include "boss.hpp"
#include "cyclops.hpp"

//projectile headers
#include "projectile.hpp"
#include "vulcan.hpp"
#include "beam.hpp"
#include "projectilefactory.hpp"

//powerup
#include "powerup.hpp"

//game state headers
#include "gamestate.hpp"
#include "creditstate.hpp"
#include "titlestate.hpp"
#include "playstate.hpp"
#include "gameoverstate.hpp"
#include "gamestatemanager.hpp"

//utility headers
#include "movementgenerator.hpp"

#endif
