#ifndef _GAMESTATE_H_
#define _GAMESTATE_H_

class GameState
{
    protected:
        GameState();
    public:
        virtual ~GameState();
    public:
        virtual void init() = 0;
        virtual void pause() = 0;
        virtual void run() = 0;
        virtual void update() = 0;
        virtual void clean() = 0;
    private:
        void loadLevel(int level);
        void unloadLevel(int level);               
};    

#endif
