#include "globals.h"

GameManager::GameManager()
{
}

GameManager::~GameManager()
{
    destroy_bitmap(page1);
    destroy_bitmap(page2);    
    destroy_bitmap(buffer);
}

//TODO: improve this function
void GameManager::initialize()
{
   //create buffer image for double buffering
   buffer = create_bitmap(SCREEN_W, SCREEN_H);    
   
   //and the pages for page-flipping
   page1 = create_video_bitmap(SCREEN_W, SCREEN_H);
   page2 = create_video_bitmap(SCREEN_W, SCREEN_H);
   
   currentPage = page2;    
}    

void GameManager::flipPage()
{    
    show_video_bitmap(currentPage);
    
    if (currentPage == page1)
    {
        currentPage = page2;
    }
    else
    {
        currentPage = page1;
    }        
}    

void GameManager::blitBuffer()
{
    acquire_screen();
    
    blit(buffer, screen, 0, 0, 0, 0, GAME_WIDTH, GAME_HEIGHT);
    
    release_screen();
    
    clear_bitmap(buffer);
} 

BITMAP* GameManager::page1;
BITMAP* GameManager::page2;
BITMAP* GameManager::currentPage;

BITMAP* GameManager::buffer;

const short int GameManager::GAME_WIDTH = 640;
const short int GameManager::GAME_HEIGHT = 480;
const short int GameManager::COLOR_DEPTH = 16;

int GameManager::game_score;
