#include "globals.h"


GameBackground::GameBackground(BITMAP* bitmap, BackgroundScrollType scrollType, int scrollSpeed, int x, int y)
{
    this->bitmap = bitmap;
    this->scrollType = scrollType;
    this->scrollSpeed = scrollSpeed;
    this->x = x;
    this->y = y;
    
    tmpBuffer = create_bitmap(SCREEN_W, SCREEN_H);
    //tmpBuffer = create_video_bitmap(SCREEN_W, SCREEN_H);
}    

GameBackground::~GameBackground()
{
    destroy_bitmap(tmpBuffer);
}

void GameBackground::update()
{
    scrollBackground();
}

void GameBackground::scrollBackground()
{
    switch(scrollType)
    {
        case HORIZONTAL_LEFT:
            scrollLeft();
            break;
        default:
            break;
    }    
}

void GameBackground::draw()
{
    //draw_sprite(GameManager::currentPage, tmpBuffer, 0, 0);
    draw_sprite(GameManager::buffer, tmpBuffer, 0, 0);
}    

void GameBackground::setScrollSpeed(int speed)
{
    scrollSpeed = speed;
}    

void GameBackground::scrollLeft()
{
    x -= scrollSpeed;
    
    int bw = bitmap->w;
    int bh = bitmap->h;
    
    int xOffSet = (SCREEN_W + bw);
    
    if ( x > bw || x < -(bw) )
    { 
        x = 0;
    }    
    
    int newX = 0;
    
    for (int i = -(bw); i < (xOffSet); i += bw)
    {
        newX = (x + i);
        
        for (int j = 0; j < SCREEN_H; j += bh)
        {
            //draw tile
            //Optimization: draw only parts that are visible to the screen            
            if ( ( newX + bw) > 0 )
            {
                draw_sprite(tmpBuffer, bitmap, newX, j);    
            }
            else
            {
                break;
            }    
                    
        }    
    }
}                 
