#include "globals.h"

//declare all functions used
int initAllegro();
void deinitAllegro();

int main(int* argc, char* argv[])
{
    //initialize allegro
    if ( initAllegro() == -1 )
    {        
        return -1;
    }

    GameManager::initialize();

    //push states to gameStateManager stack
    GameStateManager::pushState( TitleState::getInstance() );     
    GameStateManager::getCurrentState()->init();
    GameStateManager::getCurrentState()->run();//--execute run method
    GameStateManager::popState(); //--pop the element on top    
                    
    //deinitialize allegro
    deinitAllegro();
    
    return 0;
}
END_OF_MAIN()

int initAllegro()
{
    allegro_init();
    install_keyboard();
   
    install_timer();

    set_color_depth(GameManager::COLOR_DEPTH);    

    if ( set_gfx_mode(GFX_AUTODETECT, GameManager::GAME_WIDTH, GameManager::GAME_HEIGHT, 0, 0) != 0 )
    {
        allegro_message("Graphics Mode Could Not Be Set!: %s", allegro_error);
        return -1; 
    }
    
    if ( install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, 0) )
    {
        allegro_message("Sound Error: %s", allegro_error);
    }    
    
    set_volume(255, 255);

    LOCK_VARIABLE(GameTimer::game_ticker);
    LOCK_FUNCTION(GameTimer::incrementGameTicker);
    
    //install_int(GameTimer::incrementGameTicker, 10);
    install_int_ex(GameTimer::incrementGameTicker, BPS_TO_TIMER(100) );
        
    return 0;
}

void deinitAllegro()
{    
    allegro_exit();
}                           
