#include "globals.h"

EnemyFactory::~EnemyFactory()
{
}

Enemy* EnemyFactory::getEnemy(char ch)
{
    BITMAP* bitmap = NULL;
    Enemy* e = NULL;
    Weapon* w = NULL;
                
    switch(ch)
    {
        case 'O':
            bitmap = BitmapManager::getBitmap(ASTEROID_SPRITE_FLYING);
            //Asteroid::Asteroid(int x, int y, int w, int h, int sp, Status stat, int lfe, int rRate)
            return new Asteroid(1000, 700, (bitmap->w / 4), bitmap->h, 2, ALIVE, 50, MAX_ENEMY_RECOVERY_RATE);
        case 'B':
            bitmap = BitmapManager::getBitmap(BULLET_HEAD_SPRITE_FLYING);
            return new BulletHead(1000, 700, (bitmap->w / 4), bitmap->h, 2, ALIVE, 25, MAX_ENEMY_RECOVERY_RATE);             
        case 'S':
            bitmap = BitmapManager::getBitmap(SWIRL_SPRITE_FLYING);
            e = new Swirl(1000, 700, (bitmap->w / 4), bitmap->h, 1, ALIVE, 30, MAX_ENEMY_RECOVERY_RATE);
            
            w = dynamic_cast<WeaponCarrier*>(e)->getCurrentWeapon();
            w->setFireRate(50);         
            w->incrementWeaponLevel();
            
            e->setAction( new PredefinedAttackAction(e, PlayState::ship, *(new int [10][10]) ) );
            
            MovementGenerator::generateMovementFromFile( pack_fopen("ai/zigzagx.fai", "r") );
            
            return e;                          
        case 's':
            bitmap = BitmapManager::getBitmap(SWIRL_SPRITE_FLYING);
            e = new Swirl(1000, 700, (bitmap->w / 4), bitmap->h, 1, ALIVE, 1, MAX_ENEMY_RECOVERY_RATE);
            dynamic_cast<WeaponCarrier*>(e)->getCurrentWeapon()->setFireRate(30);
            e->setAction( new AttackRetreatAction(e) );
            
            return e;             
        default:            
            return NULL;
    }    
}    

std::vector<Enemy*> EnemyFactory::enemyPool;    
