#ifndef _ENEMY_H_
#define _ENEMY_H_

class Enemy : public Sprite
{
    protected:
        Animation* normalStateAnimation;
        Animation* hitStateAnimation;
        Animation* dyingStateAnimation;
        
        Action* currentAction;
        
        int recoveryTime;
        int recoveryRate; 
        
        int life;
        
        bool screamed; //scream when dying
    public:
        virtual ~Enemy();
    public:
        virtual bool isDying();                    
        virtual void takeDamage(int damagePoint);  
        
        bool isRecovering();
        void recover();  
        
        virtual void setAction(Action* action);
};    

#endif
