#include "globals.h"

Enemy::~Enemy()
{
    delete normalStateAnimation;
    delete hitStateAnimation;
    delete dyingStateAnimation;
}

void Enemy::takeDamage(int damagePoint)
{
    life -= damagePoint;
    
    recoveryTime = MAX_ENEMY_RECOVERY_TIME;
    
    if (life <= 0)   
    {
        status = DYING;
    }
}
     

bool Enemy::isDying()
{
    return (status == DYING);
} 

void Enemy::recover()
{
    if (recoveryTime > 0)
    {
        recoveryTime -= recoveryRate;
        
        if (recoveryTime < 0)
        {
            recoveryTime = 0;
        }    
    }    
}

bool Enemy::isRecovering()
{
    return (recoveryTime > 0);
}    

void Enemy::setAction(Action* action)
{
    currentAction = action;
}      
