#include "globals.h"

Cyclops::Cyclops(int x, int y, int w, int h, int sp, Status stat, int lfe, int rRate)
{
    this->x = x;
    this->y = y;
    width = w;
    height = h;
    speed = sp;
    status = stat;
    life = lfe;    

    recoveryRate = rRate;
    recoveryTime = 0;

    screamed = false;
    playedMusic = false;

    direction = LEFT;

    bossMusic = SoundManager::getMIDI(STAGE1_BOSS_MIDI);

    normalStateAnimation = new Animation(BitmapManager::getBitmap(BOSS1_SPRITE_NORMAL),  10, 4, BY_WIDTH);
    hitStateAnimation = new Animation(BitmapManager::getBitmap(BOSS1_SPRITE_HIT),  10, 4, BY_WIDTH);
    dyingStateAnimation = new Animation(BitmapManager::getBitmap(BOSS1_SPRITE_DYING),  10, 4, BY_WIDTH);
    currentAnimation = normalStateAnimation;
    
    addWeapon(VULCAN_GUN, WeaponFactory::getWeapon(VULCAN_GUN) );
    addWeapon(VIPER_BEAM, WeaponFactory::getWeapon(VIPER_BEAM) );
    setCurrentWeapon(VIPER_BEAM);
    currentWeapon->incrementWeaponLevel();
    currentWeapon->incrementWeaponLevel();                     
}

Cyclops::~Cyclops()
{
    delete normalStateAnimation;
    delete hitStateAnimation;
    delete dyingStateAnimation;
}

void Cyclops::update()
{
    if (x < SCREEN_W && playedMusic == false)
    {
          playedMusic = true;
          stop_midi();
          play_midi(bossMusic, 0);
    } 
     
    if (status == DYING)
    {
        if (screamed == false)
        {
            play_sample( SoundManager::getSample(METEOR_DESTROYED_SFX), 255, 0, 2000, 0);
            screamed = true;                                    
        }       
               
        currentAnimation = dyingStateAnimation;
        
        if ( currentAnimation->isLastAnimationFrame() )
        {
            status = DEAD;
        }
    }
    
    if (status != DEAD)
    {
        if (status != MEDITATING)
        {
            currentAnimation->animate();                   
        }

        int currentAnimationFrame = currentAnimation->getCurrentAnimationFrameNumber();

        if ( isRecovering() )
        {
             currentAnimation = hitStateAnimation;
             currentAnimation->setCurrentAnimationFrameNumber(currentAnimationFrame);
        }
        else
        {
            if ( status != DYING )
            {
                currentAnimation = normalStateAnimation;
                currentAnimation->setCurrentAnimationFrameNumber(currentAnimationFrame);
            }            
        }

    }    
    
    currentWeapon->dragWeapon(x + width, y + (height/2) );
    currentWeapon->recharge();
    
    recover();
    
    //perform action
    if (currentAction != NULL && status != DYING && status != DEAD )
    {
        currentAction->performAction();
    }         
    
}
        
void Cyclops::move(int dx, int dy)
{
    x = dx;
    y = dy;
}    

bool Cyclops::collides(Sprite* sprite)
{
  int x = sprite->x;
  int y = sprite->y;
  int w = sprite->width;
  int h = sprite->height;   
  
  int hitAllowance = 20;
     
  return (x <= this->x + width) && (x + w >= this->x) && 
         (y <= this->y + height) && (y + h >= (this->y + hitAllowance) );
}
             
void Cyclops::draw()
{    
    draw_sprite(GameManager::buffer, currentAnimation->getCurrentAnimationFrame(), x, y);
}   

void Cyclops::addWeapon(WeaponTypes weaponType, Weapon* weapon)
{
     //add weapon to std::map
     weapon->setHostile(true);
     weaponBlueprints.insert( std::pair<WeaponTypes, Weapon*>(weaponType, weapon) );
}    

void Cyclops::fullChargeWeapon()
{
    currentWeapon->fullCharge();
}    

void Cyclops::setCurrentWeapon(WeaponTypes weaponType)
{
     currentWeapon = weaponBlueprints[weaponType];
     
     currentWeapon->dragWeapon(x + width, y);
}

Weapon* Cyclops::getCurrentWeapon()
{
    return currentWeapon;
}  

void Cyclops::fireWeapon()
{
     if (currentWeapon != NULL)
     {
         switch (direction)
         {
             case LEFT:
                  currentWeapon->fire(145);
                  break;
             case RIGHT:
                  currentWeapon->fire(0);
                  break;
             default:
                  break;       
         }                       
     }
}

void Cyclops::upgradeWeapon()
{
    currentWeapon->incrementWeaponLevel();
}
