#ifndef _CYCLOPS_H_
#define _CYCLOPS_H_

class Cyclops : public Boss, public WeaponCarrier
{
    private:        
        Weapon* currentWeapon;
        std::map<WeaponTypes, Weapon*> weaponBlueprints;            
    public:
        Cyclops(int x, int y, int w, int h, int sp, Status stat, int lfe, int rRate);
    public:
        virtual ~Cyclops();
    public:
        virtual void update();
        virtual void move(int x, int y);
        virtual void draw();
        
        virtual bool collides(Sprite* sprite);
        
        virtual void addWeapon(WeaponTypes weaponType, Weapon* weapon);
        virtual void setCurrentWeapon(WeaponTypes weaponType);
        virtual Weapon* getCurrentWeapon();
        virtual void fullChargeWeapon();
        virtual void fireWeapon();
        virtual void upgradeWeapon();
                            
};

#endif
