#include "globals.h"

CreditState::CreditState()
{
    titles = new char*[MAX_TEAM_SIZE];
    names = new char*[MAX_TEAM_SIZE];

    titles[0] = "Programmer";
    names[0] = "Armond";
    
    titles[1] = "Programmer";
    names[1] = "KeMiKuLz";
    
    titles[2] = "Graphic Designer";
    names[2] = "Maximum_Tomatoes";   

    titles[3] = "Special Thanks";
    names[3] = uconvert("Allegro.cc\nGameDev.net\nPinoyforum.net", U_CURRENT, buffer, U_UTF8, 256);
    
    
    scrollX = SCREEN_W / 2;
    scrollY = SCREEN_H;
    
    scrollSpeed = 1;
    yIncrement = 0;         
}

CreditState::~CreditState()
{
}

CreditState* CreditState::getInstance()
{
    return new CreditState();
}

void CreditState::init()
{
}


void CreditState::pause()
{
}


void CreditState::run()
{    
    while( !key[KEY_ESC] )
    {
        while (GameTimer::game_ticker > 0)
        {
            if ( key[KEY_ESC] )
            {
                break;
            }
            

            for (int i = 0; i < MAX_TEAM_SIZE; i++)
            {
                textprintf_centre_ex(GameManager::buffer, font, scrollX, scrollY + yIncrement, makecol(255, 255, 255), makecol(0, 0, 0), titles[i]);                                         
                textprintf_centre_ex(GameManager::buffer, font, scrollX, ( (scrollY + yIncrement) + 10), makecol(255, 255, 255), makecol(0, 0, 0), names[i]);                                         
                yIncrement += 50;
            }                
            
            yIncrement = 0;
            scrollY -= scrollSpeed;    
            
            if (scrollY <= -(SCREEN_H) )
            {
                scrollY = SCREEN_H;
            }    
            
            
            //control game speed
            GameTimer::game_ticker--;
                          
        
            //blit buffer
            GameManager::blitBuffer(); 
        }           
    } 
        
}


void CreditState::update()
{
}


void CreditState::clean()   
{
}


CreditState* CreditState::instance;
