#include "globals.h"

BulletHead::BulletHead(int x, int y, int w, int h, int sp, Status stat, int lfe, int rRate)
{
    this->x = x;
    this->y = y;
    width = w;
    height = h;
    speed = sp;
    status = stat;
    life = lfe;    

    recoveryRate = rRate;
    recoveryTime = 0;

    screamed = false;

    normalStateAnimation = new Animation(BitmapManager::getBitmap(BULLET_HEAD_SPRITE_FLYING),  10, 4, BY_WIDTH);
    hitStateAnimation = new Animation(BitmapManager::getBitmap(BULLET_HEAD_SPRITE_HIT),  10, 4, BY_WIDTH);
    dyingStateAnimation = new Animation(BitmapManager::getBitmap(SPRITE_EXPLOSION),  10, 4, BY_WIDTH);
    currentAnimation = normalStateAnimation;
}

BulletHead::~BulletHead()
{
}


void BulletHead::update()
{
    if (status == DYING)
    {
        if (screamed == false)
        {
            play_sample( SoundManager::getSample(METEOR_DESTROYED_SFX), 255, 0, 2000, 0);
            screamed = true;                                    
        }       
               
        currentAnimation = dyingStateAnimation;
        
        if ( currentAnimation->isLastAnimationFrame() )
        {
            status = DEAD;
        }
    }     
    
    if (status != DEAD)
    {
        currentAnimation->animate();

        int currentAnimationFrame = currentAnimation->getCurrentAnimationFrameNumber();

        if ( isRecovering() )
        {
             currentAnimation = hitStateAnimation;
             currentAnimation->setCurrentAnimationFrameNumber(currentAnimationFrame);
        }
        else
        {
            if ( status != DYING )
            {
                currentAnimation = normalStateAnimation;
                currentAnimation->setCurrentAnimationFrameNumber(currentAnimationFrame);
            }            
        }

    }

    recover();

    move(x - speed, y);
}

void BulletHead::move(int x, int y)
{
    this->x = x;
    this->y = y;
}

void BulletHead::draw()
{
    draw_sprite(GameManager::buffer, currentAnimation->getCurrentAnimationFrame(), x, y);
}    
