#ifndef _BOSS_H_
#define _BOSS_H_

class Boss : public Sprite
{
    protected:
        MIDI* bossMusic;
        Animation* normalStateAnimation;
        Animation* hitStateAnimation;
        Animation* dyingStateAnimation;
        
        Action* currentAction;
        
        int recoveryTime;
        int recoveryRate; 
        
        int life;
        
        bool screamed; //scream when dying
        bool playedMusic;                
    public:
        Boss();
    public:
        virtual ~Boss();
    public:
        virtual void setBossMusic(MIDI* mid);
        virtual MIDI* getBossMusic();
        virtual void setAction(Action* action);
        
        virtual bool isDying();                    
        virtual void takeDamage(int damagePoint);  
        
        bool isRecovering();
        void recover();                 
};


#endif
