#include "globals.h"

Boss::Boss()
{
}

Boss::~Boss()
{
}

void Boss::setBossMusic(MIDI* mid)
{
    bossMusic = mid;
}


MIDI* Boss::getBossMusic()
{
    return bossMusic;
}

void Boss::setAction(Action* action)
{
    currentAction = action;
}      

void Boss::takeDamage(int damagePoint)
{
    life -= damagePoint;
    
    recoveryTime = MAX_ENEMY_RECOVERY_TIME;
    
    if (life <= 0)   
    {
        status = DYING;
    }
}
     

bool Boss::isDying()
{
    return (status == DYING);
} 

void Boss::recover()
{
    if (recoveryTime > 0)
    {
        recoveryTime -= recoveryRate;
        
        if (recoveryTime < 0)
        {
            recoveryTime = 0;
        }    
    }    
}

bool Boss::isRecovering()
{
    return (recoveryTime > 0);
}
