#include "globals.h"

BitmapManager::BitmapManager()
{
    //can never be instantiated outside the class!!!
}    

BitmapManager::~BitmapManager()
{
} 

BITMAP* BitmapManager::addBitmap(BitmapKeys key, BITMAP* bitmap)
{
    bitmapTable.insert( std::pair<BitmapKeys, BITMAP*>(key, bitmap) );
    
    return bitmapTable[key];
}

BITMAP* BitmapManager::addBitmap(BitmapKeys key, char* fileName)
{
    BITMAP* bitmap = load_bitmap(fileName, NULL);
    
    bitmapTable.insert( std::pair<BitmapKeys, BITMAP*>(key, bitmap) );   

    return bitmap;
}    

BITMAP* BitmapManager::getBitmap(BitmapKeys key)
{     
    std::map<BitmapKeys, BITMAP*>::iterator it = bitmapTable.find(key);
    
    BITMAP* bitmap = it->second;
    
    return bitmap;
}    

bool BitmapManager::lookupBitmap(BitmapKeys key)
{   
    return ( bitmapTable.find(key) != bitmapTable.end() );       
}    

void BitmapManager::removeBitmap(BitmapKeys key)
{
    std::map<BitmapKeys, BITMAP*>::iterator it = bitmapTable.find(key);
    
    BITMAP* b = it->second;
    
    if ( it != bitmapTable.end() )
    {
        bitmapTable.erase(it);
        destroy_bitmap(b);
    }    
    
}
    
void BitmapManager::removeAll()
{
    std::map<BitmapKeys, BITMAP*>().swap(bitmapTable);
}    

std::map<BitmapKeys, BITMAP*> BitmapManager::bitmapTable;    
