#include "globals.h"


Beam::Beam(int x, int y, int w, int h, int speed, int p, bool active, bool fired, int a, bool hostile)
{    
    this->x = x;
    this->y = y;
    this->width = w;
    this->height = h;
    this->speed = speed;
    this->active = active;
    this->fired = fired;
    power = p;
    
    angle = a;
    
    this->hostile = hostile;
    
    if(hostile == true)
    {
        power *= 20;
    }
    
    animation = new Animation(BitmapManager::getBitmap(BEAM_SPRITE), 1, 1, BY_WIDTH);
}    

Beam::~Beam()
{
    //std::cout << "Deleting Beam...\n";
}

void Beam::update()
{           
    fixed fAngle = itofix(angle);
    
    int newX = 0;
    int newY = 0;
        
    if (this->x < SCREEN_W)
    {
        newX = x + ( speed * fixtoi( fcos(fAngle) ) );
        newY = y + ( speed * fixtoi( fsin(fAngle) ) );
        move(newX, newY);
       
        animation->animate();
    }   
     
}

void Beam::move(int x, int y)
{
    this->x = x;
    this->y = y;
}

void Beam::draw()
{
    draw_sprite(GameManager::buffer, animation->getCurrentAnimationFrame(), this->x, this->y);    
}
