#include "globals.h"

AttackRetreatAction::AttackRetreatAction(Sprite* sp)
{
    s = sp;
    wc = dynamic_cast<WeaponCarrier*>(sp);
}


AttackRetreatAction::~AttackRetreatAction()
{
}


void AttackRetreatAction::performAction()
{
    if (s->x > ( SCREEN_W * (.75) ) )
    {
        s->move(s->x - s->speed, s->y);
    }
    else
    {
        if ( !( s->isRetreating() ) )
        {
            s->setStatus(RETREATING);                   
            s->speed *= 3;
            
            //smartswirl is higher than the center of the screen
            if (s->y < (SCREEN_H / 2) )
            {
                direction = UP;
            }
            else
            {
                direction = DOWN;
            }
            
        }
        
        switch(direction)
        {
            case UP:
                 s->move( (s->x + s->speed) , (s->y - s->speed) );
                 break;
            case DOWN:
                 s->move( (s->x + s->speed), (s->y + s->speed) );
                 break;
            default:
                 break;
        }
    }    
    
    wc->getCurrentWeapon()->dragWeapon(s->x - 10, s->y + (s->height / 2) );
    wc->getCurrentWeapon()->recharge();
    
    if ( s->isVisible() && ( s->isRetreating() ) )
    {
        wc->fireWeapon();                        
    }
    
}        
