#include "globals.h"

Asteroid::Asteroid(int x, int y, int w, int h, int sp, Status stat, int lfe, int rRate)
{
    this->x = x;
    this->y = y;
    width = w;
    height = h;
    speed = sp;
    status = stat;
    life = lfe;    

    recoveryRate = rRate;
    recoveryTime = 0;

    screamed = false;

    normalStateAnimation = new Animation(BitmapManager::getBitmap(ASTEROID_SPRITE_FLYING),  10, 4, BY_WIDTH);
    hitStateAnimation = new Animation(BitmapManager::getBitmap(ASTEROID_SPRITE_HIT),  10, 4, BY_WIDTH);
    dyingStateAnimation = new Animation(BitmapManager::getBitmap(ASTEROID_SPRITE_DYING),  10, 4, BY_WIDTH);
    currentAnimation = normalStateAnimation;
}

Asteroid::~Asteroid()
{
    //std::cout << "destroying asteroid...\n";
}

void Asteroid::update()
{
    if (status == DYING)
    {
        if (screamed == false)
        {
            play_sample( SoundManager::getSample(METEOR_DESTROYED_SFX), 255, 0, 2000, 0);
            screamed = true;                                    
        }       
               
        currentAnimation = dyingStateAnimation;
        
        if ( currentAnimation->isLastAnimationFrame() )
        {
            status = DEAD;
        }
    }     
    
    if (status != DEAD)
    {
        currentAnimation->animate();

        int currentAnimationFrame = currentAnimation->getCurrentAnimationFrameNumber();

        if ( isRecovering() )
        {
             currentAnimation = hitStateAnimation;
             currentAnimation->setCurrentAnimationFrameNumber(currentAnimationFrame);
        }
        else
        {
            if ( status != DYING )
            {
                currentAnimation = normalStateAnimation;
                currentAnimation->setCurrentAnimationFrameNumber(currentAnimationFrame);
            }            
        }

    }

    recover();

    move(x - speed, y);
}

void Asteroid::move(int x, int y)
{
    this->x = x;
    this->y = y;
}

void Asteroid::draw()
{
    draw_sprite(GameManager::buffer, currentAnimation->getCurrentAnimationFrame(), x, y);
}    
