/**
Creates an animation by taking a BITMAP as an argument in the
constructor and creating several BITMAP images by dividing
(BITMAP->w and maxFrames) if ExtractionMethod is equal to
BY_WIDTH or (BITMAP->h and maxFrames) if ExtractionMethod is
equal to BY_HEIGHT.
*/

#ifndef _ANIMATION_H_
#define _ANIMATION_H_

#include "globals.h"

#include <allegro.h>

class Animation
{
    protected:
        int frameSize; //size of each frame
        
        int frameDelay; //animation delay
        int frameTick;  //how many frame ticks have elapsed
        int currentFrame;
        
        int maxFrames; //how many frames are there and will be created
        
        BITMAP** animationFrames;                                
    public:
        Animation(BITMAP* bitmap, int frameDelay, int maxFrames, FrameExtractionMethods extractionMethod);
        ~Animation();
    public:
        void previousFrame();
        void nextFrame();        
        void animate();
        
        bool isLastAnimationFrame();
        
        BITMAP* getCurrentAnimationFrame();
        
        int getCurrentAnimationFrameNumber();
        void setCurrentAnimationFrameNumber(int frameNumber);
                
};    


#endif
