#include "globals.h"

Animation::Animation(BITMAP* bitmap, int frameDelay, int maxFrames, FrameExtractionMethods extractionMethod)
{
    this->frameDelay = frameDelay;
    this->maxFrames = maxFrames;
    
    currentFrame = 0;
    frameTick = 0;
    
    //get bitmap dimensions
    int bw = bitmap->w;
    int bh = bitmap->h;

    //set frame dimensions
    int frameWidth = (int)bw / maxFrames; //e.g. 200 / 4 == 50
    int frameHeight = bh;
    
    //EXTRACT IMAGES BY_WIDTH
    int currentX = 0; //to determine the extraction coordinate

    animationFrames = new BITMAP*[maxFrames];

    for (int i = 0; i < maxFrames; i++)
    {
        animationFrames[i] = create_sub_bitmap(bitmap, currentX, 0, frameWidth, frameHeight);
        currentX += frameWidth;
    } 
    
}    

Animation::~Animation()
{
    delete[] animationFrames;
}    

void Animation::previousFrame()
{
    if (currentFrame > 0)
    {
        currentFrame--;
    }    
}

void Animation::nextFrame()
{
    if (currentFrame < maxFrames )
    {
        currentFrame ++;
        
        if ( currentFrame == maxFrames )
        {
            currentFrame = 0;
        }    
    }
    
}   

void Animation::animate()
{
    if (frameTick == frameDelay)
    {
        frameTick = 0;
        nextFrame();
    }
    
    ++frameTick;        
}   

BITMAP* Animation::getCurrentAnimationFrame()
{
    return animationFrames[currentFrame];
}     



bool Animation::isLastAnimationFrame()
{
     return (currentFrame == (maxFrames - 1) );
}

int Animation::getCurrentAnimationFrameNumber()
{
    return currentFrame;
} 

void Animation::setCurrentAnimationFrameNumber(int frameNumber)
{
    currentFrame = frameNumber;
}
