
#include "allegro.h"
#include "wddraw.h"

#if defined ALLEGRO_NO_ASM || defined ALLEGRO_USE_C

extern char *wd_dirty_lines;  /* used in WRITE_BANK() */
extern void (*update_window) (RECT *rect);  /* window updater */
extern char *gdi_dirty_lines; /* used in WRITE_BANK() */
void gfx_gdi_autolock (struct BITMAP* bmp);
void gfx_gdi_unlock (struct BITMAP* bmp);
void gfx_directx_autolock (struct BITMAP* bmp);
void gfx_directx_unlock (struct BITMAP* bmp);

static void update_dirty_lines (BITMAP *bmp) {
	int i;
	RECT rect;
	rect.left = 0;
	rect.right = bmp->w;
	for (i = 0; i < bmp->h; i++) {
		if (wd_dirty_lines[i]) {
			int j = i+1;
			rect.top = i;
			for (; wd_dirty_lines[j]; j++) {
			}
			rect.bottom = j;
			update_window(&rect);
			i = j+1;
		}
	}
}

uintptr_t gfx_directx_write_bank (BITMAP *bmp, int line) {
	if (!(bmp->id & BMP_ID_LOCKED)) 
		gfx_directx_autolock(bmp);
	return (uintptr_t) bmp->line[line];
}

void gfx_directx_unwrite_bank (BITMAP *bmp) {
	if (!(bmp->id & BMP_ID_AUTOLOCK)) return;
	gfx_directx_unlock(bmp);
	bmp->id &= ~ BMP_ID_AUTOLOCK;
}

uintptr_t gfx_directx_write_bank_win (BITMAP *bmp, int line) {
	wd_dirty_lines[bmp->y_ofs+line] = 1;
	if (!(bmp->id & BMP_ID_LOCKED)) gfx_directx_autolock(bmp);
	return (uintptr_t) bmp->line[line];
}

void gfx_directx_unwrite_bank_win (BITMAP *bmp) {
	if (!(bmp->id & BMP_ID_AUTOLOCK)) return;
	gfx_directx_unlock(bmp);
	bmp->id &= ~BMP_ID_AUTOLOCK;
	update_dirty_lines(gfx_directx_forefront_bitmap);
	return;
}

void gfx_directx_unlock_win (BITMAP *bmp) {
	gfx_directx_unlock(bmp);
	if (!(gfx_directx_forefront_bitmap->id & BMP_ID_LOCKED))
		update_dirty_lines(gfx_directx_forefront_bitmap);
	return;
}

uintptr_t gfx_gdi_write_bank (BITMAP *bmp, int line) {
	gdi_dirty_lines[bmp->y_ofs] = 1;
	if (!(bmp->id & BMP_ID_LOCKED)) gfx_gdi_autolock(bmp);
	return (uintptr_t) bmp->line[line];
}

void gfx_gdi_unwrite_bank (BITMAP *bmp) {
	if (!(bmp->id & BMP_ID_AUTOLOCK)) return;
	gfx_gdi_unlock(bmp);
	bmp->id &= ~ BMP_ID_AUTOLOCK;
}
#endif//defined ALLEGRO_NO_ASM || defined ALLEGRO_USE_C
