#include "crops.h"

/***************/
/** Timerloop **/
/***************/

volatile int counter=0;
volatile bool exit_application = false;

void timer_handler(void) {
  counter++;
}
END_OF_FUNCTION(my_timer_handler)


/*****************/
/** Exit button **/
/*****************/

void exit_button(void) {
  exit_application = true;
}
END_OF_FUNCTION(exit_button);


/********************/
/** Initialization **/
/********************/

int initiaze() {
    allegro_init();
    install_keyboard();
    install_timer();
    
    LOCK_VARIABLE(counter);
    LOCK_FUNCTION(timer_handler);
    install_int_ex(timer_handler,BPS_TO_TIMER(15)); /* Draai op 15 hz */

    /* Install handler when user presses X at the topright corner */
    LOCK_VARIABLE(exit_application);
    LOCK_FUNCTION(exit_button);
    set_close_button_callback(exit_button);

    set_color_depth(16);
    if(set_gfx_mode( GFX_AUTODETECT_WINDOWED, SCR_WIDTH, SCR_HEIGHT, 0, 0)) exit(1);
    buffer = create_bitmap(WIDTH*32, HEIGHT*32);
    Tile::load_tileset("Gfx/Tile.bmp");
}


/***************/
/** Main loop **/
/***************/

void main_game() {
  int count=counter;
  
  for(;;) {
        while ( count == counter ) rest(20);
            count=counter;
            if(key[KEY_ESC] || exit_application) break;
            clear_keybuf();
//        draw();
  }
}


/*****************/
/** Draw screen **/
/*****************/

void draw() {
   const int width  = SCR_WIDTH/32  + ((SCR_WIDTH%32)?1:0);
   const int height = (SCR_HEIGHT-100)/32 + (((SCR_HEIGHT-100)%32)?1:0);
   int left = player_x - ((width-1)>>1);
   int top  = player_y - ((height-1)>>1);
   if (left < 0) left = 0;
   if (top  < 0) top  = 0;
   if (left + width >= WIDTH) left = WIDTH - width;
   if (top + height >= HEIGHT) top = HEIGHT - height;
   for (int x = 0; x < width; x++) {
     for (int y = 0; y < height; y++) {
       int t_x = x + left;
       int t_y = y + top;
       field[t_x][t_y]->draw_background(t_x,t_y);
       field[t_x][t_y]->draw_foreground(t_x,t_y);
     }
   }
//   player->draw_foreground(player_x, player_y);
   
//   blit(buffer,screen,left*32,top*32,0,0,SCR_WIDTH,SCR_HEIGHT-100);
     cout << "Going to draw\n";
     blit (buffer, screen, 0,0,0,0,SCR_WIDTH,SCR_HEIGHT);
}


/***************/
/** Sets game **/
/***************/

void set_game() {
     int initial_field[HEIGHT][WIDTH] = { {9, 9, 9, 9, 9, 9, 9},
                                          {9, 0, 1, 1, 1, 2, 9},     
                                          {9, 3, 4, 4, 4, 3, 9},
                                          {9, 3, 4, 4, 4, 3, 9},                                                                                    
                                          {9, 3, 4, 4, 4, 3, 9},                                                                                    
                                          {9, 6, 7, 7, 7, 8, 9},                                                    
                                          {9, 9, 9, 9, 9, 9, 9}                                          
     };
     
     for (int x = 0; x < HEIGHT; x++) {
         for (int y = 0; y < WIDTH; y++) {
             field[x][y] = new Tile;          
             field[x][y]->set_sprite(initial_field[x][y]);
         }    
     }
     
}
