#include "stdafx.hpp"

cTile::cTile()
{}


cTile::~cTile()
{}


bool cTile::LoadTileSet(string filename, uint TileWidth, uint TileHeight)
{
     if (TileWidth == 0 || TileHeight == 0)
          return false;

     if (!m_TileSet.Load(filename.c_str()))
          return false;

     m_Cols = m_TileSet.Width() / TileWidth;
     m_Rows = m_TileSet.Height() / TileHeight;
     m_TileWidth         = TileWidth;
     m_TileHeight        = TileHeight;
     m_Filename          = filename;

     // allegro_message("File: %s\nm_Cols: %i m_Rows: %i\nTileW: %i TileH: %i\nTile.W: %i Tile.H: %i", m_Filename.c_str(), m_Cols, m_Rows, m_TileWidth, m_TileHeight, m_TileSet.Width(), m_TileSet.Height());
     return true;
}


bool cTile::DrawTile(uint TileNum, uint Xpos, uint Ypos)
{
     int       tileXpos = 0;
     int       tileYpos = 0;
     // allegro_message("X: %i Y: %i", Xpos, Ypos);

     if (key[KEY_E])
     {
          allegro_message("X: %i Y: %i", Xpos, Ypos);
          //allegro_message("TN = %i / mC = %i * TH = %i", TileNum, m_Cols, m_TileHeight);
     }

     tileXpos  = ((TileNum % m_Cols) * m_TileWidth);
     tileYpos  = ((TileNum / m_Cols) * m_TileHeight);

     if (key[KEY_D])
     {
          allegro_message("TileNum: %i\nx = %f y = %f w = %f h = %f", TileNum, (float)tileXpos, (float)tileYpos, (float)m_TileHeight, (float)m_TileWidth);
     }

     // textprintf_ex(screen, font, Xpos, Ypos, makecol(255, 100, 200), -1, "%i", TileNum);
     m_TileSet.Blit((float)Xpos - tileXpos, (float)Ypos - tileYpos, Clipped((float)tileXpos, (float)tileYpos, (float)m_TileWidth, (float)m_TileHeight));

     return true;
}


int cTile::GetTileWidth()
{
     return m_TileWidth;
}


int cTile::GetTileHeight()
{
     return m_TileHeight;
}


bool cTile::Release()
{
     m_TileSet.Destroy();
     return true;
}
