#include "stdafx.hpp"

cMap::cMap()
{
     m_Tiles = NULL;
     m_Map.clear();

     m_Width        = 0;
     m_Height       = 0;
     m_NumLayers    = 0;

     Loaded         = false;
     TilesAreSet    = false;
}


cMap::~cMap()
{
     m_Tiles = NULL;
}


bool cMap::LoadMap(vector<uint> &Map, uint Width, uint Height, uint NumLayers)
{
     m_Map = Map;

     if (m_Map.empty())
          return false;

     m_Width        = Width;
     m_Height       = Height;
     m_NumLayers    = NumLayers;
     Loaded         = true;

     return true;
}


bool cMap::LoadMapFromFile(string Filename, char delimiter)
{
     uint buf;
     uint rows;
     uint columns;
     uint layers;
     vector<uint> map;
     string stack;

     fstream mapfile;
     mapfile.open(Filename.c_str(), ios::in);

     if (mapfile.is_open())
     {
          mapfile >> rows >> columns >> layers;

          map.reserve(rows * columns * layers);

          // Loop by TeamTerradactyl@Allegro.ccForums

          for (int curLayer = 0; curLayer < layers; curLayer++)
          {
               for (int curRow = 0; curRow < rows; curRow++)
               {
                    for (int curCol = 0; curCol < columns; curCol++)
                    {
                         mapfile >> buf;
                         map.push_back(buf);
                    }
               }
          }

          // Leaving this loop how it is for now until map files are completly thought up
          /*while(!mapfile.eof())
          {
           do
           {
            buf = mapfile.get();
            /*if(buf != EOF && buf != delimiter && buf != '\n')
               stack += buf;*/
          // If the buf is in readable range.
          /*
          if((buf >= 48 && buf <= 57) || (buf >= 65 && buf <= 90) || (buf >= 97 && buf <= 122))
           stack += buf;
          }
          while(buf != delimiter && !mapfile.eof() && buf != '\n');
          printf("%s\n", stack.c_str());
          map.push_back((uint)atoi(stack.c_str()));
          buf = 0;
          stack.clear();
          }*/
     }
     else
     {
          allegro_message("Error:  Couldn't open %s correctly.", Filename.c_str());
          printf("Error:  Couldn't open %s correctly.", Filename.c_str());
     }

     mapfile.close();

     m_Map          = map;
     m_Height       = rows;
     m_Width        = columns;
     m_NumLayers    = layers;

     if (m_Map.empty())
          return false;

     Loaded = true;
     return true;
}


bool cMap::SetTileSet(cTile* tiles)
{
     if ((m_Tiles = tiles) == NULL)
          return false;

     TilesAreSet    = true;

     return true;
}


bool cMap::Draw(uint Xpos, uint Ypos, uint Layer)
{
     // Called at the right time?

     if (!TilesAreSet || !Loaded)
          return false;

     // How many Rows and Columns fit on the screen?
     const uint SRows = (SCREEN_H / m_Tiles->GetTileHeight()) + 1;
     const uint SCols = (SCREEN_W / m_Tiles->GetTileWidth()) + 1;

     // Bound the drawing to the bottom right of the map
     if ((Xpos + SCols) > m_Width)
          Xpos = m_Width - SCols + 1;

     if ((Ypos + SRows) > m_Height)
          Ypos = m_Height - SRows + 1;

     int Column     = Xpos;
     int Row        = Ypos;
     int Xpixel     = 0;
     int Ypixel     = 0;
     uint TileNumber = 0;

     while (Row < SRows && Ypixel < m_Height * m_Tiles->GetTileHeight())
     {
          while (Column < SCols && Xpixel < m_Width * m_Tiles->GetTileWidth())
          {
               int arrayIndex = Row * m_Width + Column;
               // TileNumber = m_Map[(Row * m_Width + Column) * Layer];
               TileNumber = m_Map.at((Row * m_Width + Column) * Layer);
               m_Tiles->DrawTile(TileNumber, Xpixel, Ypixel);
               Column++;
               Xpixel += m_Tiles->GetTileWidth();
          }

          Xpixel = 0;

          Column = Xpos;
          Ypixel += m_Tiles->GetTileHeight();
          Row++;
     }

     return true;
}
