#include <allegro.h>


#include "linkawakes.h" // Include the header file created by the grabber utility.

int main(int argc, char *argv[])
{
   allegro_init(); // Initialize Allegro
   install_keyboard(); // Initialize keyboard routines

   set_color_conversion(COLORCONV_24_TO_32);//???

   set_color_depth(32); // Set the color depth

   set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640,480,0,0); // Change our graphics mode to 640x480

   BITMAP *buffer = create_bitmap(640,480); // Create a buffer for smooth animation.

   // Check that the buffer was created correctly
   if(buffer == NULL)
   {
      set_gfx_mode(GFX_TEXT,0,0,0,0);
      allegro_message("Could not create buffer!");
      exit(EXIT_FAILURE);
   }
   
   DATAFILE *my_datafile = load_datafile("linksawakening.dat");
   
   // Check that the datafile was created correctly
   if(my_datafile == NULL)
   {
      set_gfx_mode(GFX_TEXT,0,0,0,0);
      allegro_message("Could not load datafile!");
      exit(EXIT_FAILURE);
   }

    while(!key[KEY_ESC]) // Keep going until we hit escape.
    {
      
      draw_sprite(buffer, (BITMAP*)my_datafile[0].dat, 0, 0);
   
      blit(buffer, screen, 0, 0, 0, 0, 640, 480);//Blit the buffer
      clear(buffer);//Clear the buffer
      }

      //Destroy all bitmaps
      destroy_bitmap(buffer);

      unload_datafile(my_datafile);

      return 0;
}
END_OF_MAIN()

   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
