/////////////////////////////////////////////////////////////////////////
// Game Programming All In One, Second Edition
// Source Code Copyright (C)2004 by Jonathan S. Harbour
// Tank War Enhancement 7 - main.c
/////////////////////////////////////////////////////////////////////////

//Note: Dev-C++ has a problem with multiple source files, so I've 
//resorted to just using #include on them instead of using the project.
#include "link.h"
#include "mappyal.c"
//#include "input.c"
//#include "setup.c"
//#include "link.c"

//will erase sprite
void erasesprite(BITMAP *dest, SPRITE *spr)
{
    //erase the sprite using BLACK color fill
    rectfill(dest, spr->x, spr->y, spr->x + spr->width, 
        spr->y + spr->height, BLACK);
}

//perform basic collision detection
int inside(int x,int y,int left,int top,int right,int bottom)
{
    if (x > left && x < right && y > top && y < bottom)
        return 1;
    else
        return 0;
}

//reuse our friendly tile grabber from chapter 9
BITMAP *grabframe(BITMAP *source, 
                  int width, int height, 
                  int startx, int starty, 
                  int columns, int frame)
{
    BITMAP *temp = create_bitmap(width,height);
    int x = startx + (frame % columns) * width;
    int y = starty + (frame / columns) * height;
    blit(source,temp,x,y,0,0,width,height);
    return temp;
}

//link.c
void animatelink()
{
    if (++link->framecount > link->framedelay)
    {
        link->framecount = 0;
        link->curframe += link->animdir;
        if (link->curframe > link->maxframe)
            link->curframe = 0;
        else if (link->curframe < 0)
            link->curframe = link->maxframe;
    }
}

void drawlink()
{
    int dir = link->dir;
    int x = link->x;//-15;
    int y = link->y;//-15;
    draw_sprite(buffer, link_img[link->curframe], x, y); //link->x/y??

    
}

void movelink()
{
     int dir = link->dir;

     //update character position based on direction
     switch(dir)
     {
        //west
        case 1:
            link->x -= num1;
            //scrollx -= num1;
            break;
        
        //north
        case 2:
            link->y -= num1;//
            //scrolly -= num1;
            break;
        
        //east
        case 3:
            link->x += num1;
            //scrollx += num1;
            break;
        
        //south
        case 4:
            link->y += num1;
            //scrolly += num1;
            break;
        
        //northeast
        case 5:
            link->x += num2;
            link->y -= num2;
            //scrollx += num2;
            //scrolly += num2;
            break;
            
        //souteast    
        case 6:
             link->x += num2;
             link->y += num2;
             //scrollx += num2;
             //scrolly += num2;
             break;
             
        //southwest
        case 7:
             link->x -= num2;
             link->y += num2;
             //scrollx -= num2;
             //scrolly += num2;
             break;
        
        //northwest
        case 8:
             link->x -= num2;
             link->y -= num2;
             //scrollx -= num2;
             //scrolly -= num2;
             break;
    }

/*
    //border/edge detection
    if (scrollx > SCREEN_W-22)//mapwidth*mapblockwidth - SCROLLW)
        scrollx += SCREEN_W;//mapwidth*mapblockwidth - SCROLLW;
        
    if (scrollx < 0)
        scrollx = 0;
        
    if (scrolly > SCREEN_H-24)//mapheight*mapblockheight - SCROLLH)
        scrolly += SCREEN_H-24;//mapheight*mapblockheight - SCROLLH;

    if (scrolly < 0)
        scrolly = 0;
*/

if(scrolly < 0) scrolly = 0;
if(scrolly > BOTTOM) scrolly=BOTTOM;
if(scrollx < 0) scrollx = 0;
if(scrollx > LEFT) scrollx=LEFT;
  
  
    //border/edge detection
    if (link->x > SCREEN_W-22)
    {
          link->x = 0;
          scrollx += SCREEN_W;
    }   
    else if (link->x < 0)
    {
           link->x = SCREEN_W-22;
           scrollx -= SCREEN_W;
    }   
    else if (link->y > SCREEN_H-24)
    {
       link->y = 0;
       scrolly += SCREEN_H;
    }

    else if (link->y < scrolly)//0)
    {
         if(scrolly-SCREEN_H > 0)
         {
           scrolly -=SCREEN_H;     
           link->y = SCREEN_H-24;
         }
    }

}

//setup.c
//#include "link.h"

void setup_frames()
{
    BITMAP *temp;
    //int anim;
    int n;


    

    //load link
    //load 12-frame tiled sprite image
     temp = load_bitmap("linkss.bmp", NULL);

     for (n=0; n<12; n++)
            link_img[n] = grabframe(temp,30,30, 0,0,3,n); 
            
         //configure player 1's tank
    link = &mylink;
    link->x = 30;
    link->y = 40;
    link->width = link_img[0]->w;
     link->height = link_img[0]->h;
//    link->xspeed = 0;
//link->xdelay = 1;
     link->ydelay = 0;
     link->xcount = 0;
     link->ycount = 0;
    link->dir = 1;
    link->curframe = 0;
    link->maxframe = 11;
    link->framecount = 0;
    link->framedelay = 1;
    //link->animdir = 0;
            
    
     destroy_bitmap(temp);

    //center tanks inside scroll windows
   // link->x = 5 + SCROLLW/2;
   // link->y = 90 + SCROLLH/2;
   // link->x = 325 + SCROLLW/2;
   // link->y = 90 + SCROLLH/2;

}

void setupscreen()
{
    int ret;

    //set video mode    
    set_color_depth(16);
    ret = set_gfx_mode(MODE, WIDTH, HEIGHT, 0, 0);
    if (ret != 0) {
        allegro_message(allegro_error);
        return;
    }

    text_mode(-1);

    //load screen background
/*    back = load_bitmap("background.bmp", NULL);
    if (back == NULL)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Error loading background.bmp file");
        return;
    }
*/
    //create the double buffer
    buffer = create_bitmap(WIDTH, HEIGHT);
    if (buffer == NULL)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Error creating double buffer");
        return;
    }

    //position the radar
    //radarx = 270;
    //radary = 1;

    //position each player
    //scrollx = 100;
    //scrolly = 100;

    //position the scroll windows
    startx = 5;
    starty = 93;
}




//input.c
void getinput()
{
    //hit ESC to quit
    //if (key[KEY_ESC])   gameover = 1;
    
    //WASD - SPACE keys control tank 1
    if(key[KEY_UP])            north();
    if(key[KEY_RIGHT])         east();
    if(key[KEY_LEFT])          west();
    if(key[KEY_DOWN])          south();

    if((key[KEY_UP]) && (key[KEY_RIGHT])) 
       northeast();

    if((key[KEY_RIGHT]) && (key[KEY_DOWN]))
       southeast();
       
    if((key[KEY_LEFT]) && (key[KEY_DOWN]))
       southwest();
       
    if((key[KEY_LEFT]) && (key[KEY_UP]))
       northwest();

    //short delay after keypress        
    rest(10);
}



void updatesprite(SPRITE *spr)
{
  
    if (++spr->xcount > spr->xdelay)
        spr->xcount = 0;
    
    //update y position
    if (++spr->ycount > spr->ydelay)
        spr->ycount = 0;

    //update frame based on dir
    if (++spr->framecount > spr->framedelay)
    {
        spr->framecount = 0;
        
        //west && southwest
        if(spr->dir == 1 || spr->dir == 7)
        {
            spr->curframe++;
            if (spr->curframe < 0)
                spr->curframe = 2;
            else if(spr->curframe > 2)
                 spr->curframe = 0;
        }
        
        //north && northeast && northwest
        else if (spr->dir == 2 || spr->dir == 5 || spr->dir == 8)
        {
             ++spr->curframe; 
             if(spr->curframe < 3)
                spr->curframe = 5;
             else if(spr->curframe > 5)
                 spr->curframe = 3;
        }
        
        //east && southeast
        else if(spr->dir == 3 || spr->dir == 6)
        {
             ++spr->curframe;
             if(spr->curframe < 6)
                spr->curframe = 8;
             else if(spr->curframe > 8)
                  spr->curframe = 6;
        }
        
        //south
        else if(spr->dir == 4)
        {
             if(spr->curframe != 11) 
                              spr->curframe++;
                    
             
             if(spr->curframe == 11)
                  spr->curframe = 9;
             
             else if(spr->curframe < 9)
                spr->curframe = 11;
              
        }       
    }
}


//main function
void main(void)
{
    int anim;
    

    //initialize the game
    allegro_init(); 
    install_keyboard(); 
    install_timer();
    srand(time(NULL));
    setupscreen();    

    setup_frames();

    //load the Mappy file
    if (MapLoad("map1.fmp"))
    {
        allegro_message ("Can't find map1.fmp");
        return;
    }

    //set palette
    MapSetPal8();

    //game loop
    while(!key[KEY_ESC])
    {
        
        textprintf(screen, font,  0, 20, WHITE, "SCREEN_W:   %d", SCREEN_W);
        textprintf(screen, font,  0, 40, WHITE, "SCREEN_H:   %d", SCREEN_H);
        
        //move link
        movelink();
        
        link->dir = 0;
        
        animatelink();

        //concept for making the map move...
        //if x+=(num1 or num2) is equal to 
        //ScreenW and y+= ScreenH, nudge
        //map over....
        
        
        MapDrawBG(buffer, scrollx, scrolly, 
        0, 0, SCREEN_W-1, SCREEN_H-1);


        //draw link
        drawlink();

        //refresh the screen
        acquire_screen();
        blit(buffer, screen, 0, 0, 0, 0, WIDTH-1, HEIGHT-1);
        release_screen();

        //check for keypresses
        if (keypressed())
            getinput();
            
        //erase the sprite	
        erasesprite(buffer, link); 
        
        updatesprite(link); 

        //slow the game down
        rest(50);
    }

    //destroy bitmaps
    destroy_bitmap(back);
    destroy_bitmap(buffer);
    
    //free tank bitmaps
    for (anim=0; anim<12; anim++)
            destroy_bitmap(link_img[n]);


    //free the MappyAL memory
    MapFreeMem();

    return;
}
END_OF_MAIN();



