#ifndef _LINK_H
#define _LINK_H

//Note: Dev-C++ has a problem with multiple source files, so I've 
//resorted to just using #include on them instead of using the project.
#include <stdlib.h>
#include "allegro.h"
//#include "mappyal.h"


//define some game constants
#define MODE GFX_AUTODETECT_WINDOWED
#define WIDTH 640
#define HEIGHT 480
#define MAXSPEED 4
//#define BULLETSPEED 10
#define TILEW 32
#define TILEH 32
#define TILES 39
#define COLS 10
#define MAP_ACROSS 31
#define MAP_DOWN 33



#define MAPW MAP_ACROSS * TILEW
#define MAPH MAP_DOWN * TILEH
#define SCROLLW 310
#define SCROLLH 375

#define BOTTOM  MAPH-HEIGHT
#define LEFT    MAPW-WIDTH

//define some colors
//#define TAN makecol(255,242,169)
//#define BURST makecol(255,189,73)
#define BLACK makecol(0,0,0)
#define WHITE makecol(255,255,255)
//#define GRAY makecol(128,128,128)
//#define GREEN makecol(0,255,0)

//define the sprite structure
typedef struct SPRITE
{
    int dir, alive;
    int x,y;
    int width,height;
    int xspeed,yspeed;
    int xdelay,ydelay;
    int xcount,ycount;
    int curframe,maxframe,animdir;
    int framecount,framedelay;
}SPRITE;


//might need to fix this...
BITMAP *link_img[12];
SPRITE mylink;
SPRITE *link;

//declare some variables
int gameover;
//int scores[2];
int scrollx=LEFT, scrolly=BOTTOM;//WAS 0,0
int startx, starty;
int tilex, tiley, n;
int num1 = 6, num2 = 4;
int totalx =0, totaly=0;

int flag = 0;
//sprite bitmaps
/*
BITMAP *tank_bmp[2][8][8];
BITMAP *bullet_bmp;
BITMAP *explode_bmp;
*/

//double buffer
BITMAP *buffer;

//screen background
BITMAP *back;

//function prototypes
void animatelink();


void drawlink();
void eraselink();
void movelink();

void north()          { link->dir = 2; }
void south()          { link->dir = 4; }
void west()           { link->dir = 1; }
void east()           { link->dir = 3; }
void northeast()      { link->dir = 5; }
void southeast()      { link->dir = 6; }     
void southwest()      { link->dir = 7; } 
void northwest()      { link->dir = 8; }

void getinput();

void setupscreen();


void setup_frames();
void calculate_position(int x, int y);
BITMAP *grabframe(BITMAP *source, int width, 
                  int height, int startx, 
                  int starty, int columns, int frame);

void setupscreen();


int inside(int,int,int,int,int,int);


BITMAP *grabframe(BITMAP *, int, int, int, int, int, int);

#endif
