#ifndef __GET_TIME_H__
#define __GET_TIME_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef signed char Sint8;
typedef unsigned char Uint8;
typedef signed short int Sint16;
typedef unsigned short int Uint16;
typedef signed int Sint32;
typedef unsigned int Uint32;
typedef signed long long int Sint64;
typedef unsigned long long int Uint64;
#define error(a) __asm{int 3}

void init_time();      //to initialize time stuff
void deinit_time();    //to de-initialize time stuff

int is_time_initialized(); //returns non-zero if init_time() has been called, otherwise 0

volatile int    get_time();     //to get the current time in milliseconds
volatile double get_time2();    //to get the current time in milliseconds at high precision
volatile Sint64 get_time3();    //to get the current time in unspecified units
//in all cases, the current time is measured relative to the call to init_time();

int idle ( int time ); //to yeild a number of milliseconds to the OS
extern int _no_idle;   //to disable the above function

#ifdef __cplusplus
}
#endif


#endif // __GET_TIME_H__

