#include "alleg.h"
#include "vector.h"
#include "triangle.h"
#include "tlist.h"
#include "ball.h"
#include "globals.h"

#define TIME_SCALE      1.0
#define BPS_COUNT       800
#define TICK_TIME       ((TIME_SCALE) * 40.0 / (BPS_COUNT))

#define GWIDTH          36.0
#define GHEIGHT         50.0
#define GSIZE           10.0
#define GWS             ( GWIDTH * GSIZE )
#define GHS             ( GHEIGHT * GSIZE )

int init();
void uninit();
void draw();
int initTriangles();

BITMAP *buffer  = NULL;
BITMAP *sbuffer = NULL;


int main( int argc, char **argv )
{
    bool keyn = false;

    if ( init() == 0 )
    {
        mouse = Vector( ( mouse_x * GWS ) / SCREEN_W,  ( mouse_y * GHS ) / SCREEN_H, 0.5 );
        ball.set( mouse );
//		ball.set(Vector(180,220,0));

        while ( !done )
        {
            if ( key[ KEY_ESC ] )
            {
                break;
            }

            mouse = Vector( ( mouse_x * GWS ) / SCREEN_W,  ( mouse_y * GHS ) / SCREEN_H, 0.5 );

            while ( mouse_b & 1 )
            {
                mouse = Vector( ( mouse_x * GWS ) / SCREEN_W,  ( mouse_y * GHS ) / SCREEN_H, 0.5 );
                ball.set( mouse );
                counter = 0;
                draw();
            }

            if ( key[ KEY_N ] )
            {
                if ( !keyn )
                {
                    showNormals = -showNormals;
                }
                keyn = true;
            }
            else
            {
                keyn = false;
            }

            draw();

            while ( counter > 0 )
            {
                counter--;
                if ( triList.calculateTick( ball, TICK_TIME ) )
                {
                    if ( key[ KEY_T ] )
                    {
                        draw();
                        while ( key[ KEY_T ] );
                        counter = 0;
                    }
                }
            }
        }
    }

    uninit();

    return 0;
}
END_OF_MAIN()

void inc_counter()
{
    counter++;
}
END_OF_FUNCTION( inc_counter );


void closehook()
{
    done = true;
}

int init()
{
    allegro_init();
    install_keyboard();
    install_timer();    
    install_mouse();

    LOCK_VARIABLE( counter );
    LOCK_FUNCTION( inc_counter );
    if ( install_int_ex( inc_counter, BPS_TO_TIMER( BPS_COUNT ) ) < 0 )
    {
        return -2;
    }

    set_window_title( "Bouncy" );
    set_window_close_hook( closehook );

    set_color_depth( desktop_color_depth() );
    if ( set_gfx_mode( GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0 ) < 0 )
    {
        allegro_message( "Graphics\n" );
        return -1;
    }

    black = makecol(   0,   0,   0 );
    red   = makecol( 255,   0,   0 );
    green = makecol(   0, 255,   0 );
    blue  = makecol(   0,   0, 255 );
    white = makecol( 255, 255, 255 );

    if ( !( buffer = create_bitmap( SCREEN_W, SCREEN_H ) ) )
    {
        allegro_message( "Buffer\n" );
        return -1;
    }

    if ( !( sbuffer = create_sub_bitmap( buffer, 
                                         ( SCREEN_W - ( GWS + 1 ) ) / 2,
                                         ( SCREEN_H - ( GHS + 1 ) ) / 2,
                                         ( GWS + 1 ),
                                         ( GHS + 1 ) ) ) )
    {
        allegro_message( "SBuffer\n" );
        return -1;
    }


    clear_bitmap( buffer );

    srand((int)time(NULL));

    if ( initTriangles() < 0 )
    {
        return -1;
    }

    return 0;
}

void uninit()
{
    if ( sbuffer )
    {
        destroy_bitmap( sbuffer );
    }

    if ( buffer )
    {
        destroy_bitmap( buffer );
    }
}

void draw()
{
    clear_to_color( buffer, white );
    
    triList.draw();

    if ( tsel )
    {
        tsel->draw();
    }

    ball.draw();


    textprintf_ex( buffer, font, 10, 20, black, -1, "Mouse:    <%.2f,%.2f>", mouse.x, mouse.y );
    line( sbuffer, mouse.x, mouse.y - 2, mouse.x, mouse.y - 10, black );
    line( sbuffer, mouse.x, mouse.y + 2, mouse.x, mouse.y + 10, black );
    line( sbuffer, mouse.x + 2, mouse.y, mouse.x + 10, mouse.y, black );
    line( sbuffer, mouse.x - 2, mouse.y, mouse.x - 10, mouse.y, black );


    acquire_bitmap( screen );
    blit( buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H );
    release_bitmap( screen );
}

int initTriangles()
{
#define tadd( a, b, c, d )     triList.add( (a) * GSIZE, (b) * GSIZE, (c) * GSIZE, (d) * GSIZE )

    double arcs = 20.0;
    double step = PI / double( arcs );
    double angle = 0.0;
    double cx = 20.5 * GSIZE;
    double cy = 15.5 * GSIZE;
    double cs = 15.5 * GSIZE;

//*//upper left diagnal
    tadd(  6, 10, 14, 18 );
    tadd( 14, 20,  6, 12 );
    tadd(  6, 12,  6, 10 );
    tadd( 14, 18, 14, 20 );
//*/
//*//lower left diagnal
    tadd(  6, 30, 14, 38 );
    tadd( 14, 40,  6, 32 );
    tadd(  6, 32,  6, 30 );
    tadd( 14, 38, 14, 40 );
//*/
//*//upper right diagnal
    tadd( 22, 18, 30, 10 );
    tadd( 30, 12, 22, 20 );
    tadd( 30, 10, 30, 12 );
    tadd( 22, 20, 22, 18 );
//*/
//*//lower right diagnal
    tadd( 22, 38, 30, 30 );
    tadd( 30, 32, 22, 40 );
    tadd( 30, 30, 30, 32 );
    tadd( 22, 40, 22, 38 );
//*/
    // top
    triList.add( 20.5 * GSIZE, 0.0, 15.5 * GSIZE, 0.0 );

    triList.add( 0.0, 15.5 * GSIZE, 0.0, GHS );
    triList.add( GWS, GHS, GWS, 15.5 * GSIZE );

    // bottom
    triList.add( 0.0, GHS, GWS, GHS );


    for ( int i = 0; i < arcs; i += 2 )
    {
        double x2 = cx + cs * cos( angle + step );
        double y2 = cy - cs * sin( angle + step );
        double x1 = cx + cs * cos( angle );
        double y1 = cy - cs * sin( angle );

        triList.add( x1, y1, x2, y2 );

        angle = angle + step;
    }

    cx = 15.5 * GSIZE;

    for ( int i = 0; i < arcs; i += 2 )
    {
        double x2 = cx + cs * cos( angle + step );
        double y2 = cy - cs * sin( angle + step );
        double x1 = cx + cs * cos( angle );
        double y1 = cy - cs * sin( angle );

        triList.add( x1, y1, x2, y2 );

        angle = angle + step;
    }


    arcs = 8;
    step = PI / double( arcs );
    cx = 18.0 * GSIZE;
    cy = 28.0 * GSIZE;
    cs = 25.0;
    for ( int i = 0; i < 4 * arcs; i += 2 )
    {
        double x1 = cx + cs * cos( angle + step );
        double y1 = cy - cs * sin( angle + step );
        double x2 = cx + cs * cos( angle );
        double y2 = cy - cs * sin( angle );

        triList.add( x1, y1, x2, y2 );

        angle = angle + step;
    }

    return 0;
}


void Triangle::draw()
{
    line( sbuffer, 
          this->vector[ 0 ].x, 
          this->vector[ 0 ].y, 
          this->vector[ 1 ].x, 
          this->vector[ 1 ].y, 
          ( this == tsel ? red : blue ) );

    if ( showNormals == 1 )
    {
        int x = int( this->vector[ 0 ].x + ( ( this->vector[ 1 ].x - this->vector[ 0 ].x ) / 2.0 ) );
        int y = int( this->vector[ 0 ].y + ( ( this->vector[ 1 ].y - this->vector[ 0 ].y ) / 2.0 ) );

        line( sbuffer, 
              x, 
              y, 
              x + 20.0 * this->normal.x, 
              y + 20.0 * this->normal.y, 
              red );
        putpixel( sbuffer, 
                  x,  
                  y, 
                  white );
    }
}
