#include "triangle.h"

Triangle *tsel = NULL;

Triangle::Triangle()
{
    vector[ 0 ] = Vector( 1.0, 0.0, 0.0 );
    vector[ 1 ] = Vector( 0.0, 1.0, 0.0 );
    vector[ 2 ] = Vector( 0.0, 0.0, 1.0 );

    mid = ( vector[ 0 ] + vector[ 1 ] + vector[ 2 ] ) / 3.0;

    normal = ( ( vector[ 1 ] - vector[ 0 ] ).crossProduct( vector[ 2 ] - vector[ 0 ] ) ).normalize();
    
    elasticity = 0.0;
}

Triangle::Triangle( Vector &v1, Vector &v2, Vector &v3 )
{
    vector[ 0 ] = Vector( v1.x, v1.y, v1.z );
    vector[ 1 ] = Vector( v2.x, v2.y, v2.z );
    vector[ 2 ] = Vector( v3.x, v3.y, v3.z );
    
    mid = ( vector[ 0 ] + vector[ 1 ] + vector[ 2 ] ) / 3.0;

    normal = ( ( vector[ 1 ] - vector[ 0 ] ).crossProduct( vector[ 2 ] - vector[ 0 ] ) ).normalize();
    
    elasticity = 0.0;
}

Triangle::~Triangle()
{
}

bool Triangle::checkInside( const Ball &ball )
{    
    static int vv[ 3 ][ 2 ] = 
    { 
        { 1, 2 },
        { 2, 0 },
        { 0, 1 }
    };
    static Vector v1;
    static Vector v2;

    for ( int i = 0; i < 3; i++ )
    {
        v1 = this->vector[ vv[ i ][ 0 ] ] - ball.pos;
        v2 = this->vector[ vv[ i ][ 1 ] ] - ball.pos;

        if ( this->normal.dotProduct( v1.crossProduct( v2 ) ) < -VZERO )
        {
            return false;
        }
    }

    return true;
}

bool Triangle::checkEdge( const Ball &ball, const Vector &edge1, const Vector edge2 )
{
    Vector toEdge1 = ball.pos - edge1;
    Vector toEdge2 = ball.pos - edge2;

    if ( toEdge1.getSquaredLength() < ( ball.radius * ball.radius ) ||
         toEdge2.getSquaredLength() < ( ball.radius * ball.radius ) )
    {
        return true;
    } 

    Vector edge = edge2 - edge1;
    double elen = edge.getLength();
    Vector edir = edge / elen;


    double pdist = edir.dotProduct( toEdge1 );

    if ( pdist < -VZERO ||
         pdist > elen ) 
    {
        return false;
    }

   Vector P_onE = edge1 + edir * pdist;
   double distToLine = ( ball.pos - P_onE ).getLength();
   
   return ( distToLine < ball.radius );
}

bool Triangle::checkCollision( const Ball &ball, double &t )
{
    static Ball newBall;
    static double plen = 0.0;
    static double len = 0.0;

    t = 0.0;

    plen = this->distance( ball.pos );
    len = this->distance( ball.pos + ball.vel );

    if ( plen >= ball.radius && len < ball.radius )
    { 
        t = 1.0 - ( ( ball.radius - len ) / ( plen - len ) );
       
        newBall.pos = ball.pos + ball.vel * t;
        newBall.vel = ball.vel;
        newBall.radius = ball.radius;

        return this->checkInside( newBall );
    }

    return this->checkEdge( ball, this->vector[ 2 ], this->vector[ 1 ] ) ||
           this->checkEdge( ball, this->vector[ 1 ], this->vector[ 0 ] ) ||
           this->checkEdge( ball, this->vector[ 0 ], this->vector[ 2 ] );
}

double Triangle::distance( const Vector &p )
{
    return this->normal.dotProduct( p - this->mid ) / this->normal.getLength();
}

double Triangle::angleBetween( Vector &p )
{
    return asin( ( this->normal.dotProduct( p ) / ( this->normal.getLength() * p.getLength() ) ) );
}

