#include "alleg.h"
#include "tlist.h"

TList::TList()
{
}

TList::~TList()
{
}

void TList::draw()
{
    for ( std::list<Triangle>::iterator it = this->tlist.begin(); 
          it != this->tlist.end(); it++ )
    {
        (*it).draw();
    }
}

void TList::add( Vector &a, Vector &b, Vector &c )
{
    this->tlist.push_back( Triangle( a, b, c ) );
}

void TList::add( Vector &a, Vector &b, Vector &c, Vector &d )
{
    this->add( a, b, c );
    this->add( c, d, a );
}

void TList::add( double x1, double y1, double x2, double y2 )
{
    this->add( Vector( x1, y1, 0.0 ), 
               Vector( x2, y2, 0.0 ), 
               Vector( x2, y2, 1.0 ), 
               Vector( x1, y1, 1.0 ) );
}

Triangle *TList::findEarliestCollision( const Ball &ball, double &delta_t )
{
    Triangle *temp = NULL;
    std::list<Triangle>::iterator it;
    double currentT = 0.0;

    for ( it = this->tlist.begin(); it != this->tlist.end(); it++ )
    {
        if ( (*it).checkCollision( ball, currentT ) )
        {
            if ( currentT < delta_t &&
                 currentT > VZERO )
            {
                delta_t = currentT;
                temp = &(*it);
            }
        }
    }

    if ( delta_t <= 1.0 )
    {
        return temp;
    }

    return NULL;
}

bool TList::calculateTick( Ball &ball )
{
    Triangle *tri = NULL;
    double time_remaining = 1.0;
    double delta_t = 99999999;
    bool hit = false;


    while( ( tri = this->findEarliestCollision( ball, delta_t ) ) )
    {
        if ( key[ KEY_ESC ] ) break;

        if ( delta_t <= time_remaining ) 
        {
            ball.pos += ball.vel * delta_t;

            ball.vel += ( gravity * delta_t );


            ball.vel += ( tri->normal * 
                          tri->normal.dotProduct( -ball.vel ) * 
                          2.0 * 
                          ( 1.0 + tri->elasticity ) );

            time_remaining -= delta_t;

            tsel = tri;
            hit = true;
        }
    }

    ball.pos += ( ball.vel * time_remaining );
    ball.vel += ( gravity * time_remaining );

    return hit;
}


