
#include "alleg.h"
#include "ball.h"
#include "globals.h"

Ball::Ball()
{
    this->pos.zero();
    this->vel.zero();
    this->radius = 8.0;
}

Ball::~Ball()
{
}

Vector Ball::get()
{
    return this->pos;
}

void Ball::set( Vector &v )
{
    this->pos = v;
    this->vel.zero();
}

void Ball::draw()
{
    circlefill( sbuffer, this->pos.x, this->pos.y, this->radius, green );
    circle( sbuffer, this->pos.x, this->pos.y, this->radius, black );

    textprintf_ex( buffer, font, 10, 30, black, -1, "Position: <%.2f,%.2f,%.2f>", this->pos.x, this->pos.y, this->pos.z );
    textprintf_ex( buffer, font, 10, 40, black, -1, "Velocity: <%.2f,%.2f,%.2f>", this->vel.x, this->vel.y, this->vel.z );
    textprintf_ex( buffer, font, 10, 50, black, -1, "Speed:    <%.2f>", this->vel.getLength() );
}

