#ifndef _ASTAR_H
#define _ASTAR_H

#ifndef NULL
#define NULL            0
#endif

#define childrenCount   8

class Astar
{
    typedef struct ANode
    {
        long   cost;
        long   distance;
        int    weight;
        int    col;
        int    row;
        int    number;
        ANode *parent;
        ANode *child[ childrenCount ];
        ANode *next;
    } ANode;

    typedef struct Astack
    {
        ANode  *node;
        Astack *next;    
    } Astack;

public:
    Astar( int **array, int width, int height );
    ~Astar();

    bool initArray( int **array, int width, int height );
    void redoarray( int **array );
    bool NewPath( int sourceCol, int sourceRow, int destCol, int destRow );
    bool haveReachedGoal();
    void pathNext();
    int getCol();
    int getRow();
    int getNumber( int col, int row );
    bool isFree( int col, int row );

    void setWeightFunc( int (*calcWeight)(int col, int row ) );
    void setDistanceFunc( int (*calcDistance)( int sourceCol, int sourceRow, int destCol, int destRow ) );

private:
    int calcWeight( int col, int row );
    int calcDistance( int sourceCol, int sourceRow, int destCol, int destRow );
    void freeNodes();
    void findPath( int sourceCol, int sourceRow, int destCol, int destRow );
    ANode *getBestNode();
    void genChildren( ANode *BestNode, int destCol, int destRow );
    void genChild( ANode *BestNode, int col, int row, int destCol, int destRow );
    ANode *getOpen( int tileNum );
    ANode *getClosed( int tileNum );
    void insertNode( ANode *Successor );
    void propDown( ANode *Old );
    void push( ANode *node );
    ANode *pop();

    int (*_calcWeight)(int col, int row );
    int (*_calcDistance)( int sourceCol, int sourceRow, int destCol, int destRow );
    ANode  *open;
    ANode  *closed;
    ANode  *path;
    Astack *stack;
    bool isPath; 
    int height;
    int width;
    int size;
    int *array;
};

#endif


