// Entry for MinorHack at September 16th at 6:00 pm
// Submitted by Onewing
// Compile with allegro!
#include "allegro.h"
#include<stdio.h>
#include<string.h>

/**************** DEFINES & MACROS *************/
#define BPP 32
#define MODE GFX_AUTODETECT_WINDOWED
#define GFX_W 640
#define GFX_H 480
#define MAX_BLOCKS 1000

/*************** CONSTANTS ********************/
#define MASK makecol(255,0,255)

/*************** GLOBAL ********************/
volatile int system_time;
volatile int ticks;
volatile int framerate;
volatile int draw_ticks;
PALETTE pal;
COLOR_MAP trans_table;
BITMAP *buffer;
BITMAP *bText;
int iTimer_Speed;
int iFrameRate;
int quit;
int over;

#define MAX_SLOGANS 10
#define MAX_CARDS MAX_SLOGANS * 2
char cText[MAX_SLOGANS][2][100];
int iText[MAX_SLOGANS][2];
int cards_showing;
int card_timer;
int score;
int intensity;
int gfx_timer;
bool up;

void timer1(void)
{
	system_time++;			
}END_OF_FUNCTION(timer1);

void frametimer(void)
{
	framerate = draw_ticks;
	draw_ticks = 0;
}END_OF_FUNCTION(frametimer);



void init()
{
	//  Allegro Library
	if(allegro_init() != 0)
	{
		allegro_message("ERROR:  Failed to initialize allegro library.  Terminating program.\n");
		allegro_message("REPORT:  %s\n", allegro_error);
		exit(0);
	}

	
	set_color_depth(BPP) ; // 24 bit colour	
	if (set_gfx_mode(MODE, GFX_W, GFX_H, 0, 0)<0)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("ERROR:  Failure to init video mode!  Terminating program.\n");
		allegro_message("REPORT:  %s\n", allegro_error);
		exit(0);
	}
	

	//  Install Timer
	if(install_timer() != 0)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("ERROR:  Failed to install timer.  Terminating program.\n");
		allegro_message("REPORT:  %s\n", allegro_error);
		exit(0);
	}
	


	//  Install Keyboard	
	if(install_keyboard() != 0)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("ERROR:  Failed to install keyboard.  Terminating program.\n");
		allegro_message("REPORT:  %s\n", allegro_error);
		exit(0);
	}	

	/*install_joystick(JOY_TYPE_AUTODETECT);
	poll_joystick();
	if(num_joysticks == 0)
	{
		allegro_message("NOTE:  No joystick could be found, but you can still use keyboard.");
	}
	startpos = joy[0].stick[0].axis[0].pos;*/


	//  Install Mouse
	if(install_mouse() < 0)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("ERROR:  Failed to install mouse.  Terminating program.\n");
		allegro_message("REPORT:  %s\n", allegro_error);
		exit(0);
	}
	
	text_mode(MASK);	
	reserve_voices(32,-1); ///Reserves more channels of sound for us
	
	//  Install Sound
	if(install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0)	
	{
		allegro_message("ERROR:  Failure to install sound.  Attempting to run without sound.\n");
		allegro_message("REPORT:  %s\n", allegro_error);
		if(install_sound(DIGI_NONE, MIDI_NONE, NULL) != 0)
		{
			allegro_message("ERROR:  Failed to install sound.  Terminating program.\n");
			allegro_message("REPORT:  %s\n", allegro_error);
			exit(0);
		}		
	}
		
	srand( (unsigned) time(NULL));
	
	// Install Time Handler
	LOCK_VARIABLE(system_time);
	LOCK_VARIABLE(ticks);
	LOCK_VARIABLE(framerate);
	LOCK_VARIABLE(draw_ticks);
	LOCK_FUNCTION(timer1);
	LOCK_FUNCTION(frametimer);
	iTimer_Speed = 60;
	install_int_ex(timer1, BPS_TO_TIMER(iTimer_Speed));
	install_int_ex(frametimer, BPS_TO_TIMER(1));
	//install_int(timer1, 1000);
	
	// Setup the buffer
	buffer = create_bitmap(GFX_W, GFX_H);
	bText = create_bitmap(GFX_W, GFX_H);

	// Setup translucent table
	create_trans_table(&trans_table, pal, 0, 0, 0, NULL);	
	color_map = &trans_table;	
}

//**************** Classes ***********************
class CARD
{
public:
	int x,y;	
	int w,h;
	int iValue;
	int iType;
	bool lock;
	bool show_text;

	CARD();
	~CARD();

	void update();
	void draw(BITMAP *bDisplay);
	void init();
	void flip();

	void pick_slogan();
};

CARD::CARD()
{
	init();
}

CARD::~CARD()
{
}

void CARD::update()
{
	if(mouse_x > x && mouse_x < x + w &&
		mouse_y > y && mouse_y < y + h &&
		mouse_b & 1 && !lock)
		flip();
}

void CARD::flip()
{
	show_text = true;
	cards_showing++;
	lock = true;
	score++;

	if(cards_showing >= 2)
		card_timer = ticks;
}

void CARD::draw(BITMAP *bDisplay)
{
	if(!show_text)
	{
		rectfill(bDisplay, x, y, x+w, y+h, makecol(200,0,0));
		rect(bDisplay, x, y, x+w, y+h, makecol(255,0,0));
		rect(bDisplay, x+1, y+1, x+w-1, y+h-1, makecol(225,0,0));
	}
	else
		textprintf_centre(bText, font, x+(w/2), y + (h/2), makecol(255,255,255), cText[iValue][iType]);
}

void CARD::pick_slogan()
{
	int x = rand() % MAX_SLOGANS;
	int y = rand() % 2;

	while(iText[x][y] != 0)
	{
		x = rand() % MAX_SLOGANS;
		y = rand() % 2;
	}

	iText[x][y] = 1;
	iValue = x;
	iType = y;
}

void CARD::init()
{
	x = 0;
	y = 0;
	h = 0;
	w = 0;
	iValue = 0;
	iType = 0;
	show_text = false;
	lock = false;
}

class CARDS
{
public:
	CARD *cCards[MAX_CARDS];
	CARDS();
	~CARDS();

	void update();
	void draw(BITMAP *bDisplay);
	void init();

	void clear_cards();
};

CARDS::CARDS()
{
	init();
}

CARDS::~CARDS()
{
}

void CARDS::update()
{
	
	if(cards_showing < 2)
	{
		for(int i = 0; i < MAX_CARDS; i++)
			if(cCards[i] != NULL)
			cCards[i]->update();
	}
	else
	{
		if(abs(ticks - card_timer) > 100)
		{
			card_timer = INT_MAX;
			clear_cards();
		}
	}
}

void CARDS::clear_cards()
{
	int index = -1, S1 = -1;
	bool have_card = false;
	for(int i = 0; i < MAX_CARDS; i++)
		if(cCards[i] != NULL)
		{
			if(S1 == -1)
			{
				if(cCards[i]->show_text)
				{
					index = i;
					S1 = cCards[i]->iValue;
				}
			}
			else
			{
				if(cCards[i]->show_text && S1 == cCards[i]->iValue)
				{
					delete cCards[index];
					delete cCards[i];
					cCards[index] = NULL;
					cCards[i] = NULL;
				}
			}					
		}
	

	for(int i = 0; i < MAX_CARDS; i++)
		if(cCards[i] != NULL)
		{
			have_card = true;
			cCards[i]->show_text = false;
			cCards[i]->lock = false;
		}
		
	if(have_card == false)
	{
		quit = true;
		over = true;
	}
	cards_showing = 0;
}

void CARDS::draw(BITMAP *bDisplay)
{
	for(int i = 0; i < MAX_CARDS; i++)
		if(cCards[i] != NULL)
		cCards[i]->draw(bDisplay);
}

void CARDS::init()
{
	int size = 100;
	int X = 50, Y = 10, W = size, H = size;
	for(int i = 0; i < MAX_CARDS; i++)
	{
		cCards[i] = new CARD;
		cCards[i]->x = X;
		cCards[i]->y = Y;
		cCards[i]->w = W;
		cCards[i]->h = H;
		cCards[i]->pick_slogan();

		X += size + 10;
		if(X > 630 - size)
		{
			X = 10;
			Y += size + 10;
		}
	}
}

CARDS *cCard_Deck;

void create_slogans()
{
	strcpy(cText[0][0], "We try harder."); strcpy(cText[0][1], "Avis");
	strcpy(cText[1][0], "Go to work on an egg."); strcpy(cText[1][1], "Egg Marketing Board");
	strcpy(cText[2][0], "Guinness is good for you."); strcpy(cText[2][1], "Guinness");
	strcpy(cText[3][0], "Don't be vague. Ask for Haig."); strcpy(cText[3][1], "Haig Scotch Whisky");
	strcpy(cText[4][0], "Happiness is a cigar called Hamlet."); strcpy(cText[4][1], "Hamlet");
	strcpy(cText[5][0], "Heineken refreshes the parts other beers cannot reach."); strcpy(cText[5][1], "Heineken");
	strcpy(cText[6][0], "Beanz Meanz Heinz."); strcpy(cText[6][1], "Heinz");
	strcpy(cText[7][0], "It is.  Are you?"); strcpy(cText[7][1], "The Independent");
	strcpy(cText[8][0], "Just do it."); strcpy(cText[8][1], "Nike");
	strcpy(cText[9][0], "Think small."); strcpy(cText[9][1], "Volkswagen");
	strcpy(cText[10][0], "The ultimate driving machine."); strcpy(cText[10][1], "BMW");

	for(int i = 0; i < MAX_SLOGANS; i++)
	{
		iText[i][0] = 0;
		iText[i][1] = 0;
	}
}

void game_init()
{
	intensity = 0;
	gfx_timer = 0;
	up = true;
	score = 0;
	card_timer = INT_MAX;
	create_slogans();
	cards_showing = 0;
	cCard_Deck = new CARDS;
	show_mouse(screen);

}

void game_update()
{
	cCard_Deck->update();
	if(abs(ticks - gfx_timer) > 5)
	{
		gfx_timer = ticks;
		if(up)
		{
			intensity++;
			if(intensity > 255)
				up = false;
		}
		else
		{
			intensity--;
			if(intensity < 0)
				up = true;
		}
	}

}

void game_draw()
{
	clear(buffer);
	rectfill(buffer, 0, 0, buffer->w, buffer->h, makecol(0, intensity,0));
	rectfill(bText, 0, 0, bText->w, bText->h, makecol(255,0,255));
	cCard_Deck->draw(buffer);
	textprintf_centre(bText, font, GFX_W / 2, 5, makecol(255,255,255), "Sloganaugh");
	textprintf(bText, font, 550, 460, makecol(255,255,255), "Flips:  %d", score);
	textprintf(bText, font, 10, 460, makecol(255,255,255), "Match the slogan with the company in the least amount of flips.");
	draw_sprite(buffer, bText, 0, 0);
	draw_sprite(screen, buffer, 0, 0);	
}

void game_shutdown()
{	
	destroy_bitmap(buffer);
}



void play_game()
{	
	iFrameRate = false;
	game_init();
	
	while(!quit)
	{
		while(!key[KEY_ESC] && !over)
		{
			while(system_time && !over)
			{
				system_time--;
				ticks++;
				game_update();				
			}		
				
			draw_ticks++;
			game_draw();

			if(iFrameRate) textprintf(screen, font, 10, 10, -1, "%d", framerate);					
		}
		quit = true;
		system_time = 0;
		ticks = 0;
	}

	game_shutdown();
}



int main()
{
	init();	

	play_game();

	return 0;
}
END_OF_MAIN()